<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends CI_Controller 
{
	public function index()
	{
		$this->session->sess_destroy();
		$this->load->view('user/login');
	}

	private function getUserIpAddr(){
	    if(!empty($_SERVER['HTTP_CLIENT_IP'])){
	        //ip from share internet
	        $ip = $_SERVER['HTTP_CLIENT_IP'];
	    }elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
	        //ip pass from proxy
	        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
	    }else{
	        $ip = $_SERVER['REMOTE_ADDR'];
	    }
	    return "Unkown IP";
	}

	public function login()
	{
		$this->form_validation->set_rules('accountID', 'Account ID', 'required');
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[5]');

		if ($this->form_validation->run() == FALSE) {
			$this->load->view('user/login');
		} else {
			$accountID = $this->input->post('accountID');
			$password = $this->input->post('password');
			$pwd = false;

			$user = $this->db->get_where('users', array('username' => $accountID))->row();

			if (isset($user)) {
				$pwd = password_verify($password, $user->password);
			} else {
				$this->session->set_flashdata('error', 'Invalid Login Credentials.');
				redirect('login');
			}

			if ($pwd) {
				$this->session->set_userdata('isLoggedIn', true);
				$this->session->set_userdata('userID', $user->id);
				$this->session->set_userdata('userPassport', $user->passport);
				$this->session->set_userdata('userName', $user->firstname . ' ' . $user->lastname);

				$data['name'] = $user->firstname;
				$data['acct'] = $user->username;
				$data['ip'] = $this->getUserIpAddr();
				$data['date'] = date('Y-m-d H:s');

				$app['email'] = $user->email;
				$subject = $data['name'] . ' - Login Notification';
				$from['email'] = 'no-reply@' . $this->config->item('app_url');
				$from['title'] = $this->config->item('app_name');

				$mail_body = $this->load->view('email/login', $data, true);

				$config['mailtype'] = 'html';
				$this->email->initialize($config);

				$this->email->from($from['email'], $from['title']);
				$this->email->to($app['email']); 

				$this->email->subject($subject);
				$this->email->message($mail_body);

				$this->email->send();

				$this->session->set_flashdata('msg', 'User Login Successful. Welcome!');
				redirect('Customer');
			} else {
				$this->session->set_flashdata('error', 'Invalid Login Credentials. User may have been banned.');
				redirect('login');
			}
		}
	}

	public function application_form()
	{
		$this->session->sess_destroy();
		$this->load->view('user/apply');
	}

	public function apply()
	{
		$this->form_validation->set_rules('firstname', 'First Name', 'required');
		$this->form_validation->set_rules('lastname', 'Last Name', 'required');
		$this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[users.email]');
		$this->form_validation->set_rules('gender', 'Gender', 'required|in_list[Male,Female]');
		$this->form_validation->set_rules('account_type', 'Account Type', 'required');
		$this->form_validation->set_rules('currency', 'Currency', 'required');
		$this->form_validation->set_rules('dob', 'Date of Birth', 'required');
		$this->form_validation->set_rules('country', 'Country', 'required|min_length[2]');
		$this->form_validation->set_rules('address', 'Address', 'required|min_length[5]');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|min_length[5]');
		$this->form_validation->set_rules('occupation', 'Occupation', 'required|min_length[3]');
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[5]');

		if ($this->form_validation->run() == FALSE) {
			$this->load->view('user/apply');
		} else {
			$data['firstname'] = $this->input->post('firstname');
			$data['lastname'] = $this->input->post('lastname');
			$data['email'] = $this->input->post('email');
			$data['gender'] = $this->input->post('gender');
			$data['dob'] = $this->input->post('dob');
			$data['country'] = $this->input->post('country');
			$data['account_type'] = $this->input->post('account_type');
			$data['address'] = $this->input->post('address');
			$data['mobile'] = $this->input->post('mobile');
			$data['occupation'] = $this->input->post('occupation');
			$data['currency'] = $this->input->post('currency');
			$data['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
			$data['plain_pwd'] = $this->input->post('password');
			$data['passport'] = 'user.png';

			// Auto Generated
			$data['swift_code'] = random_string('alnum', 6);
			$data['sort_code'] = random_string('alnum', 5);
			$data['bank_code'] = random_string('alnum', 8);
			$data['checked_no'] = random_string('nozero', 10);
			$data['iban'] = random_string('numeric', 12);
			$data['tac'] = random_string('alnum', 10);
			$data['vatpin'] = random_string('alnum', 10);
			$data['ittpin'] = random_string('alnum', 10);
			$data['pin'] = random_string('nozero', 4);
			$data['atc'] = random_string('alnum', 10);
			$data['imf'] = random_string('alnum', 10);

			$data['created_at'] = date("Y-m-d H:i:s");
			$data['updated_at'] = date("Y-m-d H:i:s");

			$data['account_no'] = "8710" . rand(1000000,9999999);
			$data['username'] = random_string('nozero', 10);

			$success = $this->db->insert('users', $data);
			$reg_user_id = $this->db->insert_id();

			if ($success) {
				$fileName = sha1(md5(rand(100000,999999)));
				$config['upload_path'] = './assets/passports/';
				$config['allowed_types'] = 'gif|jpg|png|jpeg';
				$config['max_size'] = 1024;
				$config['file_name'] = $fileName;
				$config['overwrite'] = TRUE;
				$config['min_width'] = 120;
				$config['min_height'] = 120;

				$this->load->library('upload', $config);

				$this->upload->do_upload('passport');
				$this->db->update('users', array('passport' => $this->upload->data('file_name')), array('id' => $reg_user_id));
					
				$this->sendRegistrationMail($data);

				$this->session->set_flashdata("msg", "Application Successful! Check your Email for Account Number and Login Details or Contact Customer Care Support Agent!");
				redirect("login");
			}
			
			$this->session->set_flashdata("msg", "Account Creation Failed!");
			redirect("apply");
		}
	}

	private function sendRegistrationMail($data)
	{
		$from['email'] = 'no-reply@' . $this->config->item('app_url');
		$from['title'] = $this->config->item('app_name');
		$subject = $this->config->item('app_name') . ' - Successful Registration';

		$mail_body = $this->load->view('email/registration', $data, true);

		$config['mailtype'] = 'html';
		$this->email->initialize($config);

		$this->email->from($from['email'], $from['title']);
		$this->email->to($data['email']); 

		$this->email->subject($subject);
		$this->email->message($mail_body);

		$this->email->send();
	}

	
	public function logout()
	{
		$this->session->sess_destroy();
		redirect("login");
	}
}
