<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use Twilio\Rest\Client;

class Console extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();

		if ($this->session->userdata('isAdminLoggedIn') != true) {
			$this->session->sess_destroy();
			redirect('ConsoleLogin');
		}
	}

	public function index()
	{
		$data['admin'] = $this->db->where('id', $this->session->adminID)->get('admins')->row();
		$this->load->view('admin/index', $data);
	}

	public function admins()
	{
		$data['admins'] = $this->db->get('admins')->result();
		$this->load->view('admin/admins', $data);
	}

	public function toggleUserSuspend($id)
	{
	    $user = $this->db->get_where('users', array('id' => $id))->row();

	    if (count($user) > 0) {
	        if ($user->suspended == 0) {
	            $update = $this->db->update('users', array('suspended' => 1), array('id' => $id));
	            if ($update) {
	                $this->session->set_flashdata('msg', 'User Has been Suspended!');
	                redirect('Console/users');
	            } else {
	                $this->session->set_flashdata('msg', 'Oops! Something Went Wrong. Update Failed!');
	                redirect('Console/users');
	            }
	        } else {
	            $update = $this->db->update('users', array('suspended' => 0), array('id' => $id));
	            if ($update) {
	                $this->session->set_flashdata('msg', 'User Has been Un-Suspended!');
	                redirect('Console/users');
	            } else {
	                $this->session->set_flashdata('msg', 'Oops! Something Went Wrong. Update Failed!');
	                redirect('Console/users');
	            }
	        }
	    } 
	    $this->session->set_flashdata('msg', 'User Does not Exist.');
	    redirect('Console/users');
	}
	
	public function toggleUserTransferSuspend($id)
	{
	    $user = $this->db->get_where('users', array('id' => $id))->row();

	    if (@count($user) > 0) {
	        if ($user->user_transfer == 0) {
	            $update = $this->db->update('users', array('user_transfer' => 1), array('id' => $id));
	            if ($update) {
	                $this->session->set_flashdata('msg', 'Transfer Code Will be Required for Transfer!');
	                redirect('Console/users');
	            } else {
	                $this->session->set_flashdata('msg', 'Oops! Something Went Wrong. Update Failed!');
	                redirect('Console/users');
	            }
	        } else {
	            $update = $this->db->update('users', array('user_transfer' => 0), array('id' => $id));
	            if ($update) {
	                $this->session->set_flashdata('msg', 'Transfer Code Will not be Required for Transfer!');
	                redirect('Console/users');
	            } else {
	                $this->session->set_flashdata('msg', 'Oops! Something Went Wrong. Update Failed!');
	                redirect('Console/users');
	            }
	        }
	    } 
	    $this->session->set_flashdata('msg', 'User Does not Exist.');
	    redirect('Console/users');
	}

	public function toggleAdmin($id)
	{
		$admin = $this->db->get_where('admins', array('id' => $id, 'super_admin' => 0))->row();

		if (count($admin) > 0) {
			if ($admin->status == 0) {
				$update = $this->db->update('admins', array('status' => 1), array('id' => $id));
				if ($update) {
					$this->session->set_flashdata('msg', 'Admin Has been Activated!');
					redirect('Console/admins');
				} else {
					$this->session->set_flashdata('msg', 'Oops! Something Went Wrong. Update Failed!');
					redirect('Console/admins');
				}
			} else {
				$update = $this->db->update('admins', array('status' => 0), array('id' => $id));
				if ($update) {
					$this->session->set_flashdata('msg', 'Admin Has been Deactivated!');
					redirect('Console/admins');
				} else {
					$this->session->set_flashdata('msg', 'Oops! Something Went Wrong. Update Failed!');
					redirect('Console/admins');
				}
			}
		} 
		$this->session->set_flashdata('msg', 'User Does not Exist. Or is a Super Admin.');
		redirect('Console/admins');
	}

	public function adminAdd()
	{
		$this->form_validation->set_rules('name', 'Name', 'required');
		$this->form_validation->set_rules('username', 'Username', 'required|is_unique[admins.username]');
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[5]');

		if ($this->form_validation->run() == FALSE) {
			$this->load->view('admin/admins');
		} else {
			$data['name'] = $this->input->post('name');
			$data['username'] = $this->input->post('username');
			$data['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);

			$data['created_at'] = date("Y-m-d H:i:s");

			$success = $this->db->insert('admins', $data);

			if ($success) {
				$this->session->set_flashdata("msg", "Admin Successfully Created!");
				redirect("Console/admins");
			}
			
			$this->session->set_flashdata("msg", "Account Creation Failed!");
			redirect("Console/admins");
		}
	}
	
	public function transferSetting(){
		$data['setting'] = $this->db->get('transfer_setting')->row()->value;
		$this->load->view('admin/transferSetting', $data);
	}

	public function transferSetup(){

		$type = $this->input->post('type');

		$update = $this->db->update('transfer_setting', array('value' => $type));

		$this->session->set_flashdata("msg", "Transfer Settings Has Been Changed!");
		redirect('Console/transferSetting/');

	}

	public function transactions()
	{
		$data['admin'] = $this->db->where('id', $this->session->adminID)->get('admins')->row();
		$data['users'] = $this->db->order_by('id', 'DESC')->get('users')->result();
		$data['transactions'] = $this->db->order_by('id', 'DESC')->get('transactions')->result();
		$this->load->view('admin/transactions', $data);
	}

	public function transactionAdd()
	{
		$this->form_validation->set_rules('type', 'Transaction Type', 'required|in_list[Debit,Credit]');
		$this->form_validation->set_rules('amount', 'amount', 'required');
		$this->form_validation->set_rules('narration', 'Transaction Description', 'required');
		$this->form_validation->set_rules('date', 'Transaction Date', 'required');

		if ($this->form_validation->run() == FALSE) {
			$data['admin'] = $this->db->where('id', $this->session->adminID)->get('admins')->row();
			$data['users'] = $this->db->get('users')->result();
			$data['transactions'] = $this->db->get('transactions')->result();
			$this->load->view('admin/transactions', $data);
		} else {
			$data['trans_id'] = rand(90000000, 99999999);
			$data['user_id'] = $this->input->post('user_id');
			$data['type'] = $this->input->post('type');
			$data['amount'] = $this->input->post('amount');
			$data['date'] = $this->input->post('date');
			$data['narration'] = "tx" . $data['trans_id'] . '/' . $data['date'] . '/' . $this->input->post('narration');
			$data['created_at'] = date("Y-m-d H:i:s");

			if ($data['type'] == 'Debit' && $this->app_model->user_can_debit($data['user_id'], $data['amount']) == false) {
				$this->session->set_flashdata("error", "Transfer Incomplete! Not Enough Fund.");
				redirect('Console/transactions');
			}

			$success = $this->db->insert('transactions', $data);

			$user = $this->db->get_where('users', array('id' => $this->input->post('user_id')))->row();

			//$user = $this->db->get_where('users', array('id', => $this->input->post('user_id'))->row();
			
			if ($success) {

				$data['name'] = $user->firstname;
				$data['trans_id'] = $data['trans_id'];
				$data['type'] = $this->input->post('type');
				$data['amount'] = $user->currency." ".number_format($this->input->post('amount'));
				$data['date'] = $this->input->post('date');
				$data['narration'] = $data['narration'];
				$data['balance'] = $user->currency." ".number_format($this->app_model->get_user_account_balance($this->input->post('user_id')), 2);

				$app['email'] = $user->email;
				$subject = $data['name'] . ' - Transaction Notification';
				$from['email'] = 'no-reply@' . $this->config->item('app_url');
				$from['title'] = $this->config->item('app_name');

				$mail_body = $this->load->view('email/transaction', $data, true);

				$config['mailtype'] = 'html';
				$this->email->initialize($config);

				$this->email->from($from['email'], $from['title']);
				$this->email->to($app['email']); 

				$this->email->subject($subject);
				$this->email->message($mail_body);

				$this->email->send();

				if ($this->config->item('sms_enabled')) {
					$message_data['phone_number'] = $message_data['message'] = $sms_user_data = '';
				
					$sms_user_data = $user;
					$message_data['phone_number'] = $sms_user_data->mobile;

					if ($data['type'] == 'Credit') {
						$message_data['message'] = 'Your Account ' . $sms_user_data->account_no . ' Has Been Credited With ' . APP_CURRENCY . number_format($data['amount'], 2) . ' on ' . $data['created_at'] . '; via ' . $this->config->item('app_title') . '; Balance: ' . APP_CURRENCY . number_format($this->app_model->get_user_account_balance($data['user_id'])) . '; ' . $data['narration'];
					} else {
						$message_data['message'] = 'Your Account ' . $sms_user_data->account_no . ' Has Been Debited With ' . APP_CURRENCY . number_format($data['amount'], 2) . ' on ' . $data['created_at'] . '; via ' . $this->config->item('app_title') . '; Balance: ' . APP_CURRENCY . number_format($this->app_model->get_user_account_balance($data['user_id'])) . '; ' . $data['narration'];
					}

					// Call Message Function
					$this->sendAlert($message_data);
				}

				$this->session->set_flashdata("msg", "Transactionrn Creation Successful.");
				redirect('Console/transactions/');
			} else {
				$this->session->set_flashdata("error", "Transaction Creation Failed.");
				redirect('Console/transactions/');
			}
		}

		$this->session->set_flashdata("error", "Transaction Creation Failed.");
		redirect('Console/transactions/');
	}

	private function sendAlert(array $data)
	{
		// Your Account SID and Auth Token from twilio.com/console
		$account_sid = $this->config->item('twilio_account_sid');
		$auth_token = $this->config->item('twilio_auth_token');
		// In production, these should be environment variables. E.g.:
		// $auth_token = $_ENV["TWILIO_ACCOUNT_SID"]
		// A Twilio number you own with SMS capabilities
		$twilio_number = $this->config->item('twilio_number');
		$client = new Client($account_sid, $auth_token);
		
		try {
    		$client->messages->create(
    		    // Where to send a text message (your cell phone?)
    		    $data['phone_number'],
    		    array(
    		        'from' => $twilio_number,
    		        'body' => $data['message']
    		    )
    		);
		} catch (\Exception $e) {
		    $this->session->set_flashdata("error", "Transaction Created. Message Could not be sent. " . $e->getMessage());
			redirect('Console/transactions/');
		}
	}

	public function transactionDelete()
	{
		$id = $this->uri->segment(3);
		$del = $this->db->delete('transactions', array('trans_id' => $id));

		if ($del) {
			$this->session->set_flashdata("msg", "Transaction Deleted.");
			redirect('Console/transactions/');
		}

		$this->session->set_flashdata("error", "Transaction Deletion Failed.");
		redirect('Console/transactions/');
	}

	public function transfers()
	{
		$data['transfers'] = $this->db->order_by('id', 'DESC')->get('transfers')->result();
		$this->load->view('admin/transfers', $data);
	}

	public function transferDelete()
	{
		$id = $this->uri->segment(3);
		$del = $this->db->delete('transfers', array('trans_id' => $id));

		if ($del) {
			$this->session->set_flashdata("msg", "Transfer Deleted.");
			redirect('Console/transfers/');
		}

		$this->session->set_flashdata("error", "Transfer Deletion Failed.");
		redirect('Console/transfers/');
	}

	public function transferReverse()
	{
		$id = $this->uri->segment(3);
		$update = $this->db->update('transfers', array('status' => 2), array('trans_id' => $id));

		$trans = $this->db->where('trans_id', $id)->get('transfers')->row();

		$user = $this->db->where('id', $trans->user_id)->get('users')->row();

		if ($update) {


				$data['name'] = $user->firstname;
				$data['trans_id'] = $trans->trans_id;
				$data['type'] = "Reversal";
				$data['amount'] = $user->currency." ".number_format($trans->amount);
				$data['date'] = $trans->created_at;
				$data['narration'] = $trans->narration;
				$data['balance'] = $user->currency." ".number_format($this->app_model->get_user_account_balance($user->id), 2);

				$app['email'] = $user->email;
				$subject = $data['name'] . ' - Transaction Notification';
				$from['email'] = 'no-reply@' . $this->config->item('app_url');
				$from['title'] = $this->config->item('app_name');

				$mail_body = $this->load->view('email/transaction', $data, true);

				$config['mailtype'] = 'html';
				$this->email->initialize($config);

				$this->email->from($from['email'], $from['title']);
				$this->email->to($app['email']); 

				$this->email->subject($subject);
				$this->email->message($mail_body);

				$this->email->send();


			$this->session->set_flashdata("msg", "Transfer Reversed.");
			redirect('Console/transfers/');
		}

		$this->session->set_flashdata("error", "Transfer Reversals Failed.");
		redirect('Console/transfers/');
	}
	
	public function toggleTransferStatus()
	{
	    $id = $this->uri->segment(3);
		$trans = $this->db->get_where('transfers', array('trans_id' => $id))->row();

		$user = $this->db->where('id', $trans->user_id)->get('users')->row();

		if (count($trans) > 0) {
			if ($trans->status == 0) {
				$update = $this->db->update('transfers', array('status' => 1), array('trans_id' => $id));
				if ($update) {

				$data['name'] = $user->firstname;
				$data['trans_id'] = $trans->trans_id;
				$data['type'] = "Transfer/Debit";
				$data['amount'] = $user->currency." ".number_format($trans->amount);
				$data['date'] = $trans->created_at;
				$data['narration'] = $trans->narration;
				$data['balance'] = $user->currency." ".number_format($this->app_model->get_user_account_balance($user->id), 2);

				$app['email'] = $user->email;
				$subject = $data['name'] . ' - Transaction Notification';
				$from['email'] = 'no-reply@' . $this->config->item('app_url');
				$from['title'] = $this->config->item('app_name');

				$mail_body = $this->load->view('email/transaction', $data, true);

				$config['mailtype'] = 'html';
				$this->email->initialize($config);

				$this->email->from($from['email'], $from['title']);
				$this->email->to($app['email']); 

				$this->email->subject($subject);
				$this->email->message($mail_body);

				$this->email->send();


					$this->session->set_flashdata('msg', 'Transfer Status has been set to Approved!');
					redirect('Console/transfers');
				} else {
					$this->session->set_flashdata('msg', 'Oops! Something Went Wrong. Update Failed!');
					redirect('Console/transfers');
				}
			} else {
				$update = $this->db->update('transfers', array('status' => 0), array('trans_id' => $id));
				if ($update) {
					$this->session->set_flashdata('msg', 'Transfer Status has been set to Pending!');
					redirect('Console/transfers');
				} else {
					$this->session->set_flashdata('msg', 'Oops! Something Went Wrong. Update Failed!');
					redirect('Console/transfers');
				}
			}
		} 
		$this->session->set_flashdata('msg', 'The Transfer Transaction with id ' . $id . ' does not exist.');
		redirect('Console/transfers');
	}

	public function cards()
	{
		$data['cards'] = $this->db->order_by('id', 'DESC')->get('cards')->result();
		$this->load->view('admin/cards', $data);
	}

	public function cardDelete()
	{
		$id = $this->uri->segment(3);
		$del = $this->db->delete('cards', array('id' => $id));

		if ($del) {
			$this->session->set_flashdata("msg", "Card Deleted.");
			redirect('Console/cards/');
		}

		$this->session->set_flashdata("error", "Card Deletion Failed.");
		redirect('Console/cards/');
	}

	public function cardUpdate()
	{
		$action = $this->uri->segment(4);
		$id = $this->uri->segment(3);

		if (isset($action) && $action == 'update') {

			$data['expires'] = $this->input->post('expires');
			$data['status'] = $this->input->post('status');

			$update = $this->db->update('cards', $data, array('id' => $id));

			if ($update) {
				$this->session->set_flashdata("msg", "Card Updated.");
				redirect('Console/cards/');
			}

			$this->session->set_flashdata("error", "Card Update Failed.");
			redirect('Console/cards/');
		}

		$data['card'] = $this->db->where('id', $id)->get('cards')->row();
		$this->load->view('admin/cardupdate', $data);
	}

	public function loans()
	{
		$data['loans'] = $this->db->order_by('id', 'DESC')->get('loans')->result();
		$this->load->view('admin/loans', $data);
	}

	public function loanDelete()
	{
		$id = $this->uri->segment(3);
		$del = $this->db->delete('loans', array('id' => $id));

		if ($del) {
			$this->session->set_flashdata("msg", "Loan Deleted.");
			redirect('Console/loans/');
		}

		$this->session->set_flashdata("error", "Loan Deletion Failed.");
		redirect('Console/loans/');
	}

	public function loanUpdate()
	{
		$action = $this->uri->segment(4);
		$id = $this->uri->segment(3);

		if (isset($action) && $action == 'update') {

			$data['status'] = $this->input->post('status');

			$update = $this->db->update('loans', $data, array('id' => $id));

			if ($update) {
				$this->session->set_flashdata("msg", "Loan Updated.");
				redirect('Console/loans/');
			}

			$this->session->set_flashdata("error", "Loan Update Failed.");
			redirect('Console/loans/');
		}

		$data['loan'] = $this->db->where('id', $id)->get('loans')->row();
		$this->load->view('admin/loanupdate', $data);
	}

	public function users()
	{
		$data['users'] = $this->db->order_by('id', 'DESC')->get('users')->result();
		$this->load->view('admin/users', $data);
	}

	public function userAdd()
	{
		$this->load->view('admin/useradd');
	}

	public function userSave()
	{
		$this->form_validation->set_rules('firstname', 'First Name', 'required');
		$this->form_validation->set_rules('lastname', 'Last Name', 'required');
		$this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[users.email]');
		$this->form_validation->set_rules('gender', 'Gender', 'required|in_list[Male,Female]');
		$this->form_validation->set_rules('dob', 'Date of Birth', 'required');
		$this->form_validation->set_rules('country', 'Country', 'required|min_length[2]');
		$this->form_validation->set_rules('address', 'Address', 'required|min_length[5]');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|min_length[5]');
		$this->form_validation->set_rules('account_type', 'Account Type', 'required|in_list[Savings,Checking]');
		$this->form_validation->set_rules('occupation', 'Occupation', 'required|min_length[3]');
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[5]');

		if ($this->form_validation->run() == FALSE) {
			$this->load->view('admin/useradd');
		} else {
			$data['firstname'] = $this->input->post('firstname');
			$data['lastname'] = $this->input->post('lastname');
			$data['email'] = $this->input->post('email');
			$data['gender'] = $this->input->post('gender');
			$data['dob'] = $this->input->post('dob');
			$data['country'] = $this->input->post('country');
			$data['address'] = $this->input->post('address');
			$data['mobile'] = $this->input->post('mobile');
			$data['account_type'] = $this->input->post('account_type');
			$data['occupation'] = $this->input->post('occupation');
			$data['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
			$data['plain_pwd'] = $this->input->post('password');
			$data['passport'] = 'user.png';

			// Auto Generated
			$data['swift_code'] = random_string('alnum', 6);
			$data['sort_code'] = random_string('alnum', 5);
			$data['bank_code'] = random_string('alnum', 8);
			$data['checked_no'] = random_string('nozero', 10);
			$data['iban'] = random_string('numeric', 12);
			$data['tac'] = random_string('alnum', 10);
			$data['vatpin'] = random_string('alnum', 10);
			$data['ittpin'] = random_string('alnum', 10);
			$data['pin'] = random_string('nozero', 4);
			$data['atc'] = random_string('alnum', 10);
			$data['imf'] = random_string('alnum', 10);

			$data['created_at'] = date("Y-m-d H:i:s");
			$data['updated_at'] = date("Y-m-d H:i:s");

			$data['account_no'] = "8710" . rand(1000000,9999999);
			$data['username'] = random_string('nozero', 10);

			$success = $this->db->insert('users', $data);
			$reg_user_id = $this->db->insert_id();

			if ($success) {
				$fileName = sha1(md5(rand(100000,999999)));
				$config['upload_path'] = './assets/passports/';
				$config['allowed_types'] = 'gif|jpg|png|jpeg';
				$config['max_size'] = 1024;
				$config['file_name'] = $fileName;
				$config['overwrite'] = TRUE;
				$config['min_width'] = 120;
				$config['min_height'] = 120;

				$this->load->library('upload', $config);

				$this->upload->do_upload('passport');
				$this->db->update('users', array('passport' => $this->upload->data('file_name')), array('id' => $reg_user_id));
				$this->session->set_flashdata("msg", "Application Successful!");
				redirect("Console/users");
			}
			
			$this->session->set_flashdata("msg", "Account Creation Failed!");
			redirect("Console/users");
		}
	}

	public function toggleUser($id)
	{
		$user = $this->db->get_where('users', array('id' => $id))->row();

		if (count($user) > 0) {
			if ($user->status == 0) {
				$update = $this->db->update('users', array('status' => 1), array('id' => $id));
				if ($update) {
					$this->session->set_flashdata('msg', 'User Has been Activated!');
					redirect('Console/users');
				} else {
					$this->session->set_flashdata('msg', 'Oops! Something Went Wrong. Update Failed!');
					redirect('Console/users');
				}
			} else {
				$update = $this->db->update('users', array('status' => 0), array('id' => $id));
				if ($update) {
					$this->session->set_flashdata('msg', 'User Has been Deactivated!');
					redirect('Console/users');
				} else {
					$this->session->set_flashdata('msg', 'Oops! Something Went Wrong. Update Failed!');
					redirect('Console/users');
				}
			}
		} 
		$this->session->set_flashdata('msg', 'User Does not Exist.');
		redirect('Console/users');
	}

	public function userDelete()
	{
		$action = $this->uri->segment(4);
		$id = $this->uri->segment(3);

		if (isset($action) && $action == 'delete') {

			$del_transfers = $this->db->delete('transfers', array('user_id' => $id));
			$del_transactions = $this->db->delete('transactions', array('user_id' => $id));
			$del_loans = $this->db->delete('loans', array('user_id' => $id));
			$del_cards = $this->db->delete('cards', array('user_id' => $id));

			if ($del_transfers && $del_transactions && $del_loans && $del_cards) {
				
				$user = $this->db->where('id', $id)->get('users')->row();

				$del = $this->db->delete('users', array('id' => $user->id));

				unlink(base_url('assets/passports/' . $user->passport));

				$this->session->set_flashdata("msg", "User Account Deleted.");
				redirect('Console/users/');
			}

			$this->session->set_flashdata("error", "User Deletion Failed.");
			redirect('Console/users/');
		}

		$data['user'] = $this->db->where('id', $id)->get('users')->row();
		$this->load->view('admin/userdelete', $data);
	}

	public function userUpdate()
	{
		$action = $this->uri->segment(4);
		$id = $this->uri->segment(3);

		if (isset($action) && $action == 'update') {

			$data['firstname'] = $this->input->post('firstname');
			$data['lastname'] = $this->input->post('lastname');
			$data['email'] = $this->input->post('email');
			$data['gender'] = $this->input->post('gender');
			$data['dob'] = $this->input->post('dob');
			$data['country'] = $this->input->post('country');
			$data['address'] = $this->input->post('address');
			$data['mobile'] = $this->input->post('mobile');
			$data['currency'] = $this->input->post('currency');
			$data['account_type'] = $this->input->post('account_type');
			$data['occupation'] = $this->input->post('occupation');
			
			// Auto Generated
			$data['swift_code'] = $this->input->post('swift_code');
			$data['sort_code'] = $this->input->post('sort_code');
			$data['bank_code'] = $this->input->post('bank_code');
			$data['checked_no'] = $this->input->post('checked_no');
			$data['iban'] = $this->input->post('iban');
			$data['tac'] = $this->input->post('tac');
			$data['vatpin'] = $this->input->post('vatpin');
			$data['ittpin'] = $this->input->post('ittpin');
			$data['pin'] = $this->input->post('pin');
			$data['atc'] = $this->input->post('atc');
			$data['imf'] = $this->input->post('imf');

			if (!empty($this->input->post('password'))) {
				$data['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
				$data['plain_pwd'] = $this->input->post('password');
			}

			$success = $this->db->where('id', $id)->update('users', $data);

			if ($success) {

				$fileName = sha1(md5(rand(100000,999999)));
				$config['upload_path'] = './assets/passports/';
				$config['allowed_types'] = 'gif|jpg|png|jpeg';
				$config['max_size'] = 1024;
				$config['file_name'] = $fileName;
				$config['overwrite'] = TRUE;
				$config['min_width'] = 120;
				$config['min_height'] = 120;

				$this->load->library('upload', $config);

				$this->upload->do_upload('passport');

				$this->db->update('users', array('passport' => $this->upload->data('file_name')), array('id' => $id));

				$this->session->set_flashdata('msg', "User Account Successfully Updated!");
				redirect('Console/users/');
			}

			$this->session->set_flashdata("error", "User Account Update Failed.");
			redirect('Console/users/');
		}

		$data['user'] = $this->db->where('id', $id)->get('users')->row();
		$this->load->view('admin/userupdate', $data);
	}

	public function adminUpdatePassword()
	{
		$action = $this->uri->segment(4);
		$id = $this->uri->segment(3);

		if (isset($action) && $action == 'update') {

			$admin = $this->db->where('id', $this->session->adminID)->get('admins')->row();

			if ($admin->id == $id) {

				$this->form_validation->set_rules('password', 'Password', 'required|min_length[5]');

				if ($this->form_validation->run() == FALSE) {
					$this->session->set_flashdata("error", "Password must have atleast 5 characters.");
					redirect('Console/adminUpdatePassword/' . $admin->id);
				} else {
					$data['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);

					$update = $this->db->update('admins', $data, array('id' => $this->session->adminID));

					if ($update) {
						$this->session->set_flashdata("msg", "Your Password has been Updated.");
						redirect('Console/admins/');
					}

					$this->session->set_flashdata("msg", "Oops! Something went wrong.");
					redirect('Console/admins/');
				}
			} else {
				$this->session->set_flashdata("error", "Unauthorized Access. You can only Update your Password.");
				redirect('Console/admins/');
			}
		}

		$data['admin'] = $this->db->where('id', $id)->get('admins')->row();
		$this->load->view('admin/adminupdatepassword', $data);
	}

	public function siteInfo()
	{
		$this->load->view('admin/siteinfo');
	}
}