<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ConsoleLogin extends CI_Controller 
{
	public function index()
	{
		$this->session->sess_destroy();
		$this->load->view('admin/login');
	}

	public function login()
	{
		$this->form_validation->set_rules('username', 'User Name', 'required');
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[5]');

		if ($this->form_validation->run() == FALSE) {
			$this->load->view('admin/login');
		} else {
			$username = $this->input->post('username');
			$password = $this->input->post('password');
			$pwd = false;

			$user = $this->db->get_where('admins', array('username' => $username))->row();

			if (isset($user)) {
				$pwd = password_verify($password, $user->password);
			} else {
				$this->session->set_flashdata('error', 'Invalid Login Credentials.');
				redirect('ConsoleLogin');
			}

			if (($pwd == true) && ($user->status == 1)) {
				$this->session->set_userdata('isAdminLoggedIn', true);
				$this->session->set_userdata('adminID', $user->id);
				$this->session->set_userdata('adminName', $user->name);
				$this->session->set_flashdata('msg', 'Admin Login Successful. Welcome!');
				redirect('Console');
			} else {
				$this->session->set_flashdata('error', 'Invalid Login Credentials. Admin may have been banned.');
				redirect('ConsoleLogin');
			}
		}
	}

	

	public function logout()
	{
		$this->session->sess_destroy();
		redirect("ConsoleLogin");
	}
}
