<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Customer extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();

		if ($this->session->userdata('isLoggedIn') != true) {
			$this->session->sess_destroy();
			redirect('login');
		}
	}

	public function index()
	{
		$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
		$data['transfers'] = $this->db->limit(7)->order_by('id', 'DESC')->where('user_id', $this->session->userID)->get('transfers')->result();
		$this->load->view('user/index', $data);
	}

	public function overview()
	{
		$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
		$data['transfers'] = $this->db->limit(7)->order_by('id', 'DESC')->where('user_id', $this->session->userID)->get('transfers')->result();
		$this->load->view('user/overview', $data);
	}

	public function userUpdatePassword()
	{
		$action = $this->uri->segment(4);
		$id = $this->uri->segment(3);

		if ($id != $this->session->userID) {
			$this->session->set_flashdata("msg", "Unauthorized Access.");
			redirect('Customer/account');
		}

		if (isset($action) && $action == 'update') {

			$user = $this->db->where('id', $this->session->userID)->get('users')->row();

			if ($user->id == $id) {

				$this->form_validation->set_rules('password', 'Password', 'required|min_length[5]');

				if ($this->form_validation->run() == FALSE) {
					$this->session->set_flashdata("error", "Password must have atleast 5 characters.");
					redirect('Customer/userUpdatePassword/' . $user->id);
				} else {
					$data['password'] = password_hash($this->input->post('password'), PASSWORD_DEFAULT);
					$data['plain_pwd'] = $this->input->post('password');

					$update = $this->db->update('users', $data, array('id' => $this->session->userID));

					if ($update) {
						$this->session->set_flashdata("msg", "Your Password has been Updated.");
						redirect('Customer/account');
					}

					$this->session->set_flashdata("msg", "Oops! Something went wrong.");
					redirect('Customer/account');
				}
			} else {
				$this->session->set_flashdata("error", "Unauthorized Access. You can only Update your Password.");
				redirect('Customer/account');
			}
		}

		$data['user'] = $this->db->where('id', $id)->get('users')->row();
		$this->load->view('user/userupdatepassword', $data);
	}

	public function loan()
	{
		if ($this->uri->segment(3) == 'view') {
			$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
			$data['loans'] = $this->db->order_by('id', 'DESC')->where('user_id', $this->session->userID)->get('loans')->result();
			$this->load->view('user/loans', $data);
		} elseif ($this->uri->segment(3) == 'save') {
			$this->form_validation->set_rules('amount', 'Amount', 'required');
			$this->form_validation->set_rules('naration', 'Naration', 'required');
			$this->form_validation->set_rules('period', 'Period', 'required');

			if ($this->form_validation->run() == FALSE) {
				$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
				$this->load->view('user/loan', $data);
			} else {
				$data['user_id'] = $this->session->userID;
				$data['amount'] = $this->input->post('amount');
				$data['naration'] = $this->input->post('naration');
				$data['period'] = $this->input->post('period');

				$data['created_at'] = date("Y-m-d H:i:s");

				$success = $this->db->insert('loans', $data);

				if ($success) {
					$this->session->set_flashdata("msg", "Loan Application Successful.");
					redirect('Customer/loan/view');
				} else {
					$this->session->set_flashdata("error", "Loan Application Failed.");
					redirect('Customer/loan/view');
				}
			}
		} else {
			$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
			$this->load->view('user/loan', $data);
		}
	}

	public function card()
	{
		if ($this->uri->segment(3) == 'view') {
			$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
			$data['cards'] = $this->db->order_by('id', 'DESC')->where('user_id', $this->session->userID)->get('cards')->result();
			$this->load->view('user/cards', $data);
		} elseif ($this->uri->segment(3) == 'save') {
			$this->form_validation->set_rules('name', 'Name', 'required|in_list[Credit Card,Debit Card,Charge Card,ATM Card,Fleet Card]');

			if ($this->form_validation->run() == FALSE) {
				$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
				$this->load->view('user/card', $data);
			} else {
				$data['user_id'] = $this->session->userID;
				$data['name'] = $this->input->post('name');
				$data['created_at'] = date("Y-m-d H:i:s");

				$success = $this->db->insert('cards', $data);

				if ($success) {
					$this->session->set_flashdata("msg", "Card Application Successful.");
					redirect('Customer/card/view');
				} else {
					$this->session->set_flashdata("error", "Card Application Failed.");
					redirect('Customer/card/view');
				}
			}
		} else {
			$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
			$this->load->view('user/card', $data);
		}
	}

	public function transactions()
	{
		$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
		$data['transactions'] = $this->db->limit(7)->order_by('id', 'DESC')->where('user_id', $this->session->userID)->get('transactions')->result();
		$this->load->view('user/transactions', $data);
	}

	public function account()
	{
		$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
		$this->load->view('user/account', $data);
	}

	public function transfer()
	{
// 		$this->app_model->userTransferSuspender();
		$this->app_model->userSuspender();
		
		if ($this->uri->segment(3) == 'view') {
			$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
			$data['transfers'] = $this->db->order_by('id', 'DESC')->where('user_id', $this->session->userID)->get('transfers')->result();
			$this->load->view('user/transfers', $data);

		} elseif ($this->uri->segment(3) == 'save') {
			$this->form_validation->set_rules('ben_bank_name', 'Beneficiary Bank Name', 'required');
			$this->form_validation->set_rules('ben_account_no', 'Beneficiary Account No', 'required');
			$this->form_validation->set_rules('ben_account_name', 'Beneficiary Account Name', 'required');
			$this->form_validation->set_rules('ben_bank_address', 'Beneficiary Bank Address', 'required');
			$this->form_validation->set_rules('country', 'Country', 'required');
			$this->form_validation->set_rules('amount', 'Amount', 'required');
			$this->form_validation->set_rules('fund_option', 'Fund Transfer Option', 'required');
			$this->form_validation->set_rules('ben_swift_code', 'Bank Swift Code', 'required');
			$this->form_validation->set_rules('narration', 'Transaction Description', 'required');

			if ($this->form_validation->run() == FALSE) {
				$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
				$this->load->view('user/transfer', $data);
			} else {
				
				if ($this->app_model->user_can_debit($this->session->userID, $this->input->post('amount')) == false) {
					$this->session->set_flashdata("error", "Transfer Incomplete! Not Enough Fund.");
					redirect('Customer/transfer');
				}

				$data['trans_id'] = random_string('numeric', 20);;
				$data['user_id'] = $this->session->userID;
				$data['ben_bank_name'] = $this->input->post('ben_bank_name');
				$data['ben_account_no'] = $this->input->post('ben_account_no');
				$data['ben_account_name'] = $this->input->post('ben_account_name');
				$data['ben_name'] = $this->input->post('ben_name');
				$data['ben_bank_address'] = $this->input->post('ben_bank_address');
				$data['country'] = $this->input->post('country');
				$data['amount'] = $this->input->post('amount');
				$data['fund_option'] = $this->input->post('fund_option');
				$data['ben_iban'] = $this->input->post('ben_iban');
				$data['ben_swift_code'] = $this->input->post('ben_swift_code');
				$data['type'] = 'Transfer';
				$data['narration'] = $this->input->post('narration');
				$data['date'] = date("Y-m-d H:i:s");
				$data['created_at'] = date("Y-m-d H:i:s");
				
				$type = $this->db->get('transfer_setting')->row()->value;

				if($type == 2){
					$data['status'] = 1;
				}else{
					$data['status'] = 0;
				}

				$success = $this->db->insert('transfers', $data);
				$transfer_id = $this->db->insert_id();

				$trans_id = $this->db->where('user_id', $this->session->userID)->where('id', $transfer_id)->get('transfers')->row()->trans_id;

				if ($success) {

				$user = $this->db->where('id', $this->session->userID)->get('users')->row();

				$data['name'] = $user->firstname;
				$data['beneficiary'] = $this->input->post('ben_account_name');
				$data['beneficiary_bank'] = $this->input->post('ben_bank_name');
				$data['beneficiary_account'] = $this->input->post('ben_account_no');
				$data['beneficiary_country'] = $this->input->post('country');
				$data['amount'] = $this->input->post('amount');
				$data['tac'] = $user->tac;

				$app['email'] = $user->email;
				$subject = $data['name'] . ' - Transfer Notification';
				$from['email'] = 'no-reply@' . $this->config->item('app_url');
				$from['title'] = $this->config->item('app_name');

				$mail_body = $this->load->view('email/otp', $data, true);

				$config['mailtype'] = 'html';
				$this->email->initialize($config);

				$this->email->from($from['email'], $from['title']);
				$this->email->to($app['email']); 

				$this->email->subject($subject);
				$this->email->message($mail_body);

				$this->email->send();

					$this->session->set_flashdata("msg", "Fund Transfer Initiated.");
					redirect('Customer/transferVerification/' . $trans_id);
				} else {
					$this->session->set_flashdata("error", "Fund Transfer Initiation Failed. Try Again.");
					redirect('Customer/transfer/view');
				}
			}
		} else {
		  //   $this->app_model->transferSuspender();
			$data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
			$this->load->view('user/transfer', $data);
		}
	}

	public function transferVerification()
	{
	   // $this->app_model->userTransferSuspender();
	   // $this->app_model->userSuspender();
	    
		$trans_id = $this->uri->segment(3);
		$trans = $this->db->where('trans_id', $trans_id)->where('user_id', $this->session->userID)->get('transfers')->row();

		if (@count($trans) == 1) {
			$data['transfer'] = $trans;
			$data['user'] = $data['user'] = $this->db->where('id', $this->session->userID)->get('users')->row();
			$this->load->view('user/transfer-verification', $data);
		} else {
			$this->session->set_flashdata('error', 'Invalid Transaction ID Supplied. Try Again.');
			redirect('Customer/transfer/view');
		}
	}

	public function transferVerify()
	{
        // $this->app_model->userTransferSuspender();
		$this->app_model->userSuspender();
		
		$trans_id = $this->uri->segment(3);
		$trans = $this->db->where('trans_id', $trans_id)->where('user_id', $this->session->userID)->get('transfers')->row();
		
		$value = $this->input->post('value');

		if (@count($trans) == 1) {

			if ($trans->step == 0) {
				$this->validateTransferCodes(1, $trans_id, 'tac', $value);
			} elseif ($trans->step == 1) {
				$this->db->where('trans_id', $trans_id)->where('user_id', $this->session->userID)->update('transfers', array('step' => 2));
				redirect('Customer/transferVerification/' . $trans_id);
			} elseif ($trans->step == 2) {
				$this->validateTransferCodes(3, $trans_id, 'imf', $value);
			} elseif ($trans->step == 3) {
				$this->validateTransferCodes(4, $trans_id, 'vatpin', $value);
			} elseif ($trans->step == 4) {
				$this->validateTransferCodes(5, $trans_id, 'atc', $value);
			} else {
				redirect('Customer/transferVerification/' . $trans_id);
			}

		}
	}

	private function validateTransferCodes($step, $trans_id, $field, $value)
	{
		// $row = $this->db->where('id', $this->session->userID)->where($field, $value)->get('users')->num_rows();
		$row = $this->db->where('id', $this->session->userID)->where($field, $value)->get('users');
		
		$dd = random_string('alnum', 10);

		if ($row->num_rows() == 1) {
			$update = $this->db->where('trans_id', $trans_id)->where('user_id', $this->session->userID)->update('transfers', array('step' => $step));
			$this->db->where('id', $this->session->userID)->where($field, $value)->update('users', array($field => $dd));

		 	if ($update == false){
		 		$this->session->set_flashdata('error', 'Validation Failed! Make Sure You Enter Correct Info!');
			 	redirect('Customer/transferVerification/' . $trans_id);
		 	}

			$this->session->set_flashdata('msg', 'Validation and Update was Successful!');
		 	redirect('Customer/transferVerification/' . $trans_id);
		}

		$this->session->set_flashdata('error', 'Validation Failed! Make Sure you input Correct Info!');
	 	redirect('Customer/transferVerification/' . $trans_id);;
	}

}