<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class App_model extends CI_Model 
{
    public function get_user_account_balance($user_id)
    {
        return (($this->get_user_credits($user_id) - $this->get_user_debits($user_id)) - $this->get_user_transfers($user_id));
    }

    public function get_user_debits($user_id)
    {
        return $this->db->where(array('user_id' => $user_id, 'type' => 'Debit'))->select_sum('amount')->get('transactions')->row()->amount;
    }

    public function get_user_credits($user_id)
    {
        return $this->db->where(array('user_id' => $user_id, 'type' => 'Credit'))->select_sum('amount')->get('transactions')->row()->amount;
    }

    public function get_user_transfers($user_id)
    {
        return $this->db->where('user_id', $user_id)->where('status =', '1')->select_sum('amount')->get('transfers')->row()->amount;
    }

    public function user_can_debit($user_id, $amount)
    {
        if ($this->get_user_credits($user_id) > ($this->get_user_debits($user_id) + $amount)) {
            return true;
        }

        return false;
    }

    public function get_all_user_balance()
    {
        return $this->db->select_sum('amount')->get('transactions')->row()->amount;
    }

    public function get_all_user_credits()
    {
        return $this->db->where('type', 'Credit')->select_sum('amount')->get('transactions')->row()->amount;
    }

    public function get_all_user_debits()
    {
        return $this->db->where('type', 'Debit')->select_sum('amount')->get('transactions')->row()->amount;
    }

    public function get_all_user_count()
    {
        return count($this->db->get('users')->num_rows());
    }

    public function get_latest_transactions($user_id)
    {
        return $this->db->limit(5)->order_by('id', 'DESC')->where('user_id', $user_id)->get('transactions')->result();
    }

    public function get_all_latest_transactions()
    {
        return $this->db->limit(20)->order_by('id', 'DESC')->get('transactions')->result();
    }

    public function get_user_status($user_id)
    {
        return $this->db->where('id', $user_id)->get('users')->row()->status;
    }

    public function user_suspended($user_id)
    {
        if (@count($this->db->where('id', $user_id)->where('suspended', 1)->get('users')->row()) > 0) {
            return true;
        }

        return false;
    }
    
    public function user_transfer_suspended($user_id)
    {
        // if (@count($this->db->where('user_id', $user_id)->get('transfers')->row()) >= 2) {
        //     return true;
        // }

        // return false;
        
        $this->db->from('transfers');
	    $this->db->where(array('user_id' => $user_id));
	    $total = $this->db->count_all_results();
	    
	    if($total >= 2) {
            return true;
        }

        return false;
    }
    
    public function transferSuspender(){
        $type = $this->db->get('transfer_setting')->row()->value;

        if($type == 0){
            $this->session->set_flashdata("t_error", "Transfers are Currently Disabled, Please try again or Contact Bank Support");
            redirect('Customer');
        }
    }

        public function userSuspender()
    {
        if ($this->user_suspended($this->session->userID)) {
            $this->session->set_flashdata("error", "Oops! Your Account Has Been Suspended.");
            redirect('Customer');
        }
    }

        public function userTransferSuspender()
    {
        if ($this->user_transfer_suspended($this->session->userID)) {
            $this->session->set_flashdata("j_error", "Your account has been blocked for security reasons, this block is due to login from an unusual location, please contact live chat customer service for help or support");
            redirect('Customer');
        }
    }


}