<?php
$this->load->view('admin/inc/header');
$this->load->view('admin/inc/sidebar');
?>  
<!-- begin #content -->
<div id="content" class="content">

    <!-- begin page-header -->
    <h1 class="page-header">Administrators</h1>
    <!-- end page-header -->
    <small>
        <?php 
        echo (!empty(validation_errors())) ? '<div class="alert alert-danger fade show">' . validation_errors() . '</div>' : ''; 
        ?>    
    </small>
    <small>
        <?php echo (!empty($this->session->flashdata('msg'))) ? '<div class="alert alert-primary fade show">' . $this->session->flashdata('msg') . '</div>' : ''; ?>
    </small>
    <small>
        <?php echo (!empty($this->session->flashdata('error'))) ? '<div class="alert alert-danger fade show">' . $this->session->flashdata('error') . '</div>' : ''; ?>
    </small>

    <div class="panel panel-primary" data-sortable-id="form-stuff-9">
        <!-- begin panel-heading -->
        <div class="panel-heading">
            <div class="panel-heading-btn">
                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-warning" data-click="panel-collapse"><i class="fa fa-minus"></i></a>
            </div>
            <h4 class="panel-title">Create Admin</h4>
        </div>
        <!-- end panel-heading -->
        <!-- begin panel-body -->
        <div class="panel-body">
            <form action="<?php echo site_url('Console/adminAdd'); ?>" method="POST">
                <fieldset>
                    <div class="form-group">
                        <label for="name">Name</label>
                        <input type="text" class="form-control" name="name" id="name" placeholder="Enter Name">
                    </div>
                    <div class="form-group">
                        <label for="username">User Name</label>
                        <input type="text" class="form-control" name="username" id="username" placeholder="Enter Username">
                    </div>
                    <div class="form-group">
                        <label for="exampleInputPassword1">Password</label>
                        <input type="password" class="form-control" name="password" id="exampleInputPassword1" placeholder="Password">
                    </div>
                    <button type="submit" class="btn btn-sm btn-primary m-r-5">Create Admin</button>
                </fieldset>
            </form>
        </div>
        <!-- end panel-body -->
        
      </div>

    <!-- begin panel -->
    <div class="panel panel-primary">
        <!-- begin panel-heading -->
        <div class="panel-heading">
            <h4 class="panel-title">Administrator</h4>
        </div>
        <!-- end panel-heading -->
        <!-- begin panel-body -->
        <div class="panel-body">
            <table id="data-table-default" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th class="text-nowrap">Admin Name</th>
                        <th class="text-nowrap">Username</th>
                        <th class="text-nowrap">Password</th>
                        <th class="text-nowrap">Status</th>
                        <th class="text-nowrap">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                        if (!empty($admins)) {
                            foreach ($admins as $admin) {
                                $status = ($admin->status == 1) ? '<span class="badge badge-success">Active</span>' : '<span class="badge badge-danger">De-activated</span>';

                                $action1 = ($admin->status == 1) ?  "<a href='" . site_url('Console/toggleAdmin/' . $admin->id) . "' class='btn btn-danger'>De-Activate</a>" : "<a href='" . site_url('Console/toggleAdmin/' . $admin->id) . "' class='btn btn-primary'>Activate</a>";

                                $action2 = "<a href='" . site_url('Console/adminUpdatePassword/' . $admin->id) . "' class='btn btn-primary'>Update Password</a>";

                                echo "
                                    <tr class='odd gradeX'>
                                        <td>" . $admin->name . "</td>
                                        <td>" . $admin->username . "</td>
                                        <td>***********</td>
                                        <td>" . $status . "</td>
                                        <td>" . $action1 . ' ' . $action2 . "</td>
                                    </tr>
                                ";
                            }
                        }
                    ?>
                </tbody>
            </table>
        </div>
        <!-- end panel-body -->
    </div>
    <!-- end panel -->


  </div>
  <!-- end #content -->

  <?php $this->load->view('admin/inc/footer'); ?>


  <!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/DataTables/media/css/dataTables.bootstrap.min.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/css/responsive.bootstrap.min.css'); ?>" rel="stylesheet" />
<!-- ================== END PAGE LEVEL STYLE ================== -->

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/jquery.dataTables.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/js/dataTables.responsive.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/table-manage-default.demo.min.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->

<script>
    $(document).ready(function() {
        App.init();
        TableManageDefault.init();
    });
</script>