				<!-- begin panel -->
			    <div class="panel panel-primary">
		        <!-- begin panel-heading -->
		        <div class="panel-heading">
		            <h4 class="panel-title">Recent Transactions</h4>
		        </div>
		        <!-- end panel-heading -->
		        <!-- begin panel-body -->
		        <div class="panel-body">
		            <table id="data-table-default" class="table table-striped table-bordered">
		                <thead>
		                    <tr>
		                        <th class="text-nowrap">Trans ID</th>
		                        <th class="text-nowrap">User (Account No.)</th>
		                        <th class="text-nowrap">Type</th>
		                        <th class="text-nowrap">Amount</th>
		                        <th class="text-nowrap">Description</th>
		                        <th class="text-nowrap">Date</th>
		                    </tr>
		                </thead>
		                <tbody>
		                    <?php 
			                    
			                    $transactions = $this->app_model->get_all_latest_transactions();

		                        if (!empty($transactions)) {
		                            foreach ($transactions as $transaction) {

		                                $user_acc = $this->db->where('id', $transaction->user_id)->get('users')->row();

		                                $type = ($transaction->type == 'Debit') ? "<span class='badge badge-danger'>Debit</span>" : "<span class='badge badge-primary'>Credit</span>";

		                                echo "
		                                    <tr class='odd gradeX'>
		                                        <td>" . $transaction->trans_id . "</td>
		                                        <td>" . $user_acc->firstname . ' ' . $user_acc->lastname . ' (' . $user_acc->account_no . ")</td>
		                                        <td>" . $type . "</td>
		                                        <td>" . APP_CURRENCY . number_format($transaction->amount, 2) . "</td>
		                                        <td>" . $transaction->narration . "</td>
		                                        <td>" . $transaction->date . "</td>
		                                    </tr>
		                                ";
		                            }
		                        }
		                    ?>
		                </tbody>
		            </table>
		        </div>
		        <!-- end panel-body -->
		    </div>
		    <!-- end panel -->