<?php
$this->load->view('admin/inc/header');
$this->load->view('admin/inc/sidebar');
?>  
<!-- begin #content -->
<div id="content" class="content">

    <!-- begin page-header -->
    <h1 class="page-header">Transactions</h1>
    <!-- end page-header -->
    <small>
        <?php 
        echo (!empty(validation_errors())) ? '<div class="alert alert-danger fade show">' . validation_errors() . '</div>' : ''; 
        ?>    
    </small>
    <small>
        <?php echo (!empty($this->session->flashdata('msg'))) ? '<div class="alert alert-primary fade show">' . $this->session->flashdata('msg') . '</div>' : ''; ?>
    </small>
    <small>
        <?php echo (!empty($this->session->flashdata('error'))) ? '<div class="alert alert-danger fade show">' . $this->session->flashdata('error') . '</div>' : ''; ?>
    </small>

    <div class="panel panel-primary" data-sortable-id="form-stuff-9">
        <!-- begin panel-heading -->
        <div class="panel-heading">
            <div class="panel-heading-btn">
                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-warning" data-click="panel-collapse"><i class="fa fa-minus"></i></a>
            </div>
            <h4 class="panel-title">Create Transaction</h4>
        </div>
        <!-- end panel-heading -->
        <!-- begin panel-body -->
        <div class="panel-body">
            <form action="<?php echo site_url('Console/transactionAdd'); ?>" method="POST">
                <fieldset>
                    <!-- begin form-group -->
                    <div class="form-group">
                        <label>User (Account) <span class="text-danger">*</span></label>
                        <select class="form-control" name="user_id" required>
                            <option value=""> -- Select User --</option>
                            <?php
                            if (!empty($users)) {
                                foreach ($users as $user) {
                                    echo "<option value='" . $user->id . "' " . set_select('user_id', $user->id) . ">" . $user->firstname . ' ' . $user->lastname . ' (' . $user->account_no . ')</option>';
                                }
                            }
                            ?>
                        </select>
                    </div>
                    <!-- end form-group -->
                    <!-- begin form-group -->
                    <div class="form-group">
                        <label>Transaction Type <span class="text-danger">*</span></label>
                        <select class="form-control" name="type" required>
                            <option value=""> -- Select Transaction Type --</option>
                            <option value="Credit" <?php echo set_select('type', 'Credit'); ?>>Credit</option>
                            <option value="Debit" <?php echo set_select('type', 'Debit'); ?>>Debit</option>
                        </select>
                    </div>
                    <!-- end form-group -->
                    <div class="form-group">
                        <label for="amount">Amount (<?php echo APP_CURRENCY; ?>)</label>
                        <input type="number" class="form-control" value="<?php echo set_value('narration'); ?>" name="amount" id="amount" placeholder="Amount" required>
                    </div>
                    <div class="form-group">
                        <label for="narration">Description</label>
                        <input type="text" class="form-control" name="narration" value="<?php echo set_value('narration'); ?>" id="narration" placeholder="Brief Description" required>
                    </div>
                    <div class="form-group">
                        <label for="datetimepicker1">Date/Time</label>
                        <div class="input-group date" id="datetimepicker1">
                            <input type="text" class="form-control" name="date" value="<?php echo set_value('date'); ?>" id="datetimepicker1">
                            <div class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-sm btn-primary m-r-5">Create Transaction</button>
                </fieldset>
            </form>
        </div>
        <!-- end panel-body -->
        
      </div>

    <!-- begin panel -->
    <div class="panel panel-primary">
        <!-- begin panel-heading -->
        <div class="panel-heading">
            <h4 class="panel-title">All Transactions</h4>
        </div>
        <!-- end panel-heading -->
        <!-- begin panel-body -->
        <div class="panel-body">
            <table id="data-table-default" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th class="text-nowrap">Trans ID</th>
                        <th class="text-nowrap">User (Account No.)</th>
                        <th class="text-nowrap">Type</th>
                        <th class="text-nowrap">Amount</th>
                        <th class="text-nowrap">Description</th>
                        <th class="text-nowrap">Date</th>
                        <th class="text-nowrap">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                        if (!empty($transactions)) {
                            foreach ($transactions as $transaction) {

                                $user_acc = $this->db->where('id', $transaction->user_id)->get('users')->row();

                                $type = ($transaction->type == 'Debit') ? "<span class='badge badge-danger'>Debit</span>" : "<span class='badge badge-primary'>Credit</span>";

                                $action = "<a href='" . site_url('Console/transactionDelete/' . $transaction->trans_id) . "' class='btn btn-danger'>Delete</a>";

                                echo "
                                    <tr class='odd gradeX'>
                                        <td>" . $transaction->trans_id . "</td>
                                        <td>" . $user_acc->firstname . ' ' . $user_acc->lastname . ' (' . $user_acc->account_no . ")</td>
                                        <td>" . $type . "</td>
                                        <td>" . APP_CURRENCY . number_format($transaction->amount, 2) . "</td>
                                        <td>" . $transaction->narration . "</td>
                                        <td>" . $transaction->date . "</td>
                                        <td>" . $action . "</td>
                                    </tr>
                                ";
                            }
                        }
                    ?>
                </tbody>
            </table>
        </div>
        <!-- end panel-body -->
    </div>
    <!-- end panel -->


  </div>
  <!-- end #content -->

  <?php $this->load->view('admin/inc/footer'); ?>


  <!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/DataTables/media/css/dataTables.bootstrap.min.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/css/responsive.bootstrap.min.css'); ?>" rel="stylesheet" />
<!-- ================== END PAGE LEVEL STYLE ================== -->

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/jquery.dataTables.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/js/dataTables.responsive.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/table-manage-default.demo.min.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->

<script>
    $(document).ready(function() {
        App.init();
        TableManageDefault.init();
    });
</script>

<!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/bootstrap-datepicker/css/bootstrap-datepicker.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/bootstrap-eonasdan-datetimepicker/build/css/bootstrap-datetimepicker.min.css'); ?>" rel="stylesheet" />

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-daterangepicker/moment.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-eonasdan-datetimepicker/build/js/bootstrap-datetimepicker.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/form-plugins.transaction.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->

<script>
    $(document).ready(function() {
        App.init();
        FormPlugins.init();
    });
</script>