<?php
$this->load->view('admin/inc/header');
$this->load->view('admin/inc/sidebar');
?>  
<!-- begin #content -->
<div id="content" class="content">

    <!-- begin page-header -->
    <h1 class="page-header">Transfer Setting</h1>
    <!-- end page-header -->
    <small>
        <?php 
        echo (!empty(validation_errors())) ? '<div class="alert alert-danger fade show">' . validation_errors() . '</div>' : ''; 
        ?>    
    </small>
    <small>
        <?php echo (!empty($this->session->flashdata('msg'))) ? '<div class="alert alert-primary fade show">' . $this->session->flashdata('msg') . '</div>' : ''; ?>
    </small>
    <small>
        <?php echo (!empty($this->session->flashdata('error'))) ? '<div class="alert alert-danger fade show">' . $this->session->flashdata('error') . '</div>' : ''; ?>
    </small>

    <div class="panel panel-primary" data-sortable-id="form-stuff-9">
        <!-- begin panel-heading -->
        <div class="panel-heading">
            <div class="panel-heading-btn">
                <a href="javascript:;" class="btn btn-xs btn-icon btn-circle btn-warning" data-click="panel-collapse"><i class="fa fa-minus"></i></a>
            </div>
            <h4 class="panel-title">Transfer Setting</h4>
        </div>

        <?php 

        switch ($setting) {
            case 0:
                $type = "Transfer Disabled";
                break;

            case 1:
                $type = "Transfer Enabled with Tranfer Codes";
                break;

            case 2:
                $type = "Transfer Enabled without Tranfer Codes";
                break;
            
            default:
                $type = "Unknown Type";
                break;
        }

        ?>
        <!-- end panel-heading -->
        <!-- begin panel-body -->
        <div class="panel-body">
            <form action="<?php echo site_url('Console/transferSetup'); ?>" method="POST">
                <fieldset>
                    <!-- begin form-group -->
                    <div class="form-group">
                        <label>Transfer Setting<span class="text-danger">*</span></label>
                        <select class="form-control" name="type" required>
                            <option value="<?php echo $setting; ?>"> <?php echo $type; ?></option>
                            <option disabled>Change Setting</option>
                            <option value="1">Enable with Transfer Code</option>
                            <option value="2">Enable without Transfer Code</option>
                            <option value="0">Disable</option>
                        </select>
                    </div>
                    <!-- end form-group -->
                   
                    <button type="submit" class="btn btn-sm btn-primary m-r-5">Save Setting </button>
                </fieldset>
            </form>
        </div>
        <!-- end panel-body -->
        
      </div>



  </div>
  <!-- end #content -->

  <?php $this->load->view('admin/inc/footer'); ?>


  <!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/DataTables/media/css/dataTables.bootstrap.min.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/css/responsive.bootstrap.min.css'); ?>" rel="stylesheet" />
<!-- ================== END PAGE LEVEL STYLE ================== -->

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/jquery.dataTables.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/js/dataTables.responsive.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/table-manage-default.demo.min.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->

<script>
    $(document).ready(function() {
        App.init();
        TableManageDefault.init();
    });
</script>

<!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/bootstrap-datepicker/css/bootstrap-datepicker.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/bootstrap-eonasdan-datetimepicker/build/css/bootstrap-datetimepicker.min.css'); ?>" rel="stylesheet" />

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-daterangepicker/moment.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-eonasdan-datetimepicker/build/js/bootstrap-datetimepicker.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/form-plugins.transaction.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->

<script>
    $(document).ready(function() {
        App.init();
        FormPlugins.init();
    });
</script>