<?php
$this->load->view('admin/inc/header');
$this->load->view('admin/inc/sidebar');
?>
		<!-- begin #content -->
		<div id="content" class="content">
			
			<!-- begin page-header -->
			<h1 class="page-header">All User Fund Transfers </small></h1>
			<!-- end page-header -->
			
			<!-- begin panel -->
			<div class="panel panel-primary">
				<!-- begin panel-heading -->
				<div class="panel-heading">
					<h4 class="panel-title">Fund Transfers</h4>
				</div>
				<!-- end panel-heading -->
				<!-- begin panel-body -->
				<div class="panel-body">
                <small>
                    <?php echo (!empty($this->session->flashdata('msg'))) ? '<div class="alert alert-primary fade show">' . $this->session->flashdata('msg') . '</div>' : ''; ?>
                </small>
                <small>
                    <?php echo (!empty($this->session->flashdata('error'))) ? '<div class="alert alert-danger fade show">' . $this->session->flashdata('error') . '</div>' : ''; ?>
                </small>

					<table id="data-table-default" class="table table-striped table-bordered">
						<thead>
							<tr>
								<th class="text-nowrap">TransID</th>
								<th class="text-nowrap">User (Account No.)</th>
								<th class="text-nowrap">Beneficiary (Account)</th>
								<th class="text-nowrap">Beneficiary Bank</th>
								<th class="text-nowrap">Amount (<?php echo APP_CURRENCY; ?>)</th>
								<th class="text-nowrap">IBAN</th>
								<th class="text-nowrap">Swift Code</th>
								<th class="text-nowrap">TFO</th>
								<th class="text-nowrap">Description</th>
								<th class="text-nowrap">Date</th>
								<th class="text-nowrap">Step</th>
								<th class="text-nowrap">Clearance Code</th>
								<th class="text-nowrap">Status</th>
								<th class="text-nowrap">Action</th>
							</tr>
						</thead>
						<tbody>
							<?php
							if (!empty($transfers)) {
							
								foreach ($transfers as $transfer) {
									
									$user = $this->db->where('id', $transfer->user_id)->get('users')->row();

									switch($transfer->status){

										case 0: 
											$status = '<span class="badge badge-danger">Pending</span>';
											break;

										case 1: 
											$status = '<span class="badge badge-success">Approved</span>';
											break;

										case 2: 
											$status = '<span class="badge badge-primary">Reversed</span>';
											break;

									}
									// $status = ($transfer->status == 1) ? '<span class="badge badge-success">Approved</span>' : '<span class="badge badge-danger">Pending</span>';

									$Step = $clearance_code = '';

									switch ($transfer->step) {
										case 0:
											$Step = 'IPN Validation (Level - ' . $transfer->step . ')';
											$clearance_code = $user->tac;
											break;

										case 1:
											$Step = 'Transfer Initiated (Level - ' . $transfer->step . ')';
											$clearance_code = 'No Clearance Required';
											break;

										case 2:
											$Step = 'VAT Clearance (Level - ' . $transfer->step . ')';
											$clearance_code = $user->vatpin;
											break;

										case 3:
											$Step = 'IMF Clearance (Level - ' . $transfer->step . ')';
											$clearance_code = $user->imf;
											break;

										case 4:
											$Step = 'Fund Reflection PIN (Level - ' . $transfer->step . ')';
											$clearance_code = $user->atc;
											break;

										case 5:
											$Step = 'Transaction Completed (Level - ' . $transfer->step . ')';
											$clearance_code = 'No Clearance Required';
											break;
										
										default:
											$Step = 'Unknown State';
											break;
									}

									$action = "<a href='" . site_url('Console/toggleTransferStatus/' . $transfer->trans_id) . "' class='btn btn-primary'>Approve/Pend</a> | ";
									$action .= "<a href='" . site_url('Console/transferDelete/' . $transfer->trans_id) . "' class='btn btn-danger'>Delete</a> |";
									$action .= "<a href='" . site_url('Console/transferReverse/' . $transfer->trans_id) . "' class='btn btn-warning'>Reverse</a>";
									
									echo "
										<tr class='odd gradeX'>
											<td>" . $transfer->trans_id . '</td>
											<td>' . $user->firstname . ' ' . $user->lastname . ' (' . $user->account_no . ')</td>
											<td>' . $transfer->ben_name . ' (' . $transfer->ben_account_name . ' ' . $transfer->ben_account_no . ')</td>
											<td>' . $transfer->ben_bank_name . ' (' . $transfer->country . ' - ' . $transfer->ben_bank_address . ')</td>
											<td>' . number_format($transfer->amount, 2) . '</td>
											<td>' . $transfer->ben_iban . '</td>
											<td>' . $transfer->ben_swift_code . '</td>
											<td>' . $transfer->fund_option . '</td>
											<td>' . $transfer->narration . '</td>
											<td>' . $transfer->date . '</td>
											<td>' . $Step . '</td>
											<td>' . $clearance_code . '</td>
											<td>' . $status . '</td>
											<td>' . $action . "</td>
										</tr>";
								}
							}
							?>
						</tbody>
					</table>
				</div>
				<!-- end panel-body -->
			</div>
			<!-- end panel -->
		
		</div>
		<!-- end #content -->

<?php $this->load->view('admin/inc/footer'); ?>

<!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/DataTables/media/css/dataTables.bootstrap.min.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/css/responsive.bootstrap.min.css'); ?>" rel="stylesheet" />
<!-- ================== END PAGE LEVEL STYLE ================== -->

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/jquery.dataTables.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/js/dataTables.responsive.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/table-manage-default.demo.min.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->

<script>
	$(document).ready(function() {
		App.init();
		TableManageDefault.init();
	});
</script>