<?php
$this->load->view('admin/inc/header');
$this->load->view('admin/inc/sidebar');
?>  
<!-- begin #content -->
<div id="content" class="content">

    <!-- begin page-header -->
    <h1 class="page-header">USER DELETION</h1>
    <!-- end page-header -->
    <small>
        <?php 
        echo (!empty(validation_errors())) ? '<div class="alert alert-danger fade show">' . validation_errors() . '</div>' : ''; 
        ?>    
    </small>
    <small>
        <?php echo (!empty($this->session->flashdata('msg'))) ? '<div class="alert alert-primary fade show">' . $this->session->flashdata('msg') . '</div>' : ''; ?>
    </small>
    <small>
        <?php echo (!empty($this->session->flashdata('error'))) ? '<div class="alert alert-danger fade show">' . $this->session->flashdata('error') . '</div>' : ''; ?>
    </small>

   <!-- begin wizard-form -->
            <form id="delete_form" action="<?php echo site_url('Console/userDelete/' . $user->id . '/delete'); ?>" method="POST" name="form-wizard" class="form-control-with-bg" >
                <!-- begin wizard -->
                <div id="wizard">
                    <!-- begin wizard-step -->
                    <ul>
                        <li class="col-12">
                            <a href="#step-1">
                                <span class="number">1</span> 
                                <span class="info text-ellipsis">
                                    Account Deletion
                                    <small class="text-ellipsis">Account Deletion Initiated</small>
                                </span>
                            </a>
                        </li>
                    </ul>
                    <!-- end wizard-step -->
                    <!-- begin wizard-content -->
                    <div>
                        <!-- begin step-1 -->
                        <div id="step-1">
                            <div class="jumbotron m-b-0 text-center">
                                <h2 class="text-inverse">User Account Deletion Initiated!</h2>
                                <div class="process-loader">
                                </div>
                                <p class="m-b-30 f-s-16">Hello Admin, you have choosen to delete a user account with the following details: <br />

                                Name: <?php echo $user->firstname . ' ' . $user->lastname; ?> <br />
                                Account No.: <?php echo $user->account_no; ?> <br />
                                <br />

                                <span class="text-danger">Note: All user data will be deleted, this includes the account details, loans, cards, transfers and any other file/record related to this user. <br />

                                If you wish to continue with this action, please click on the "DELETE USER" </span></p>
                                <p><button type="submit" class="btn btn-primary btn-lg">DELETE USER!</button></p>
                            </div>
                        </div>
                        <!-- end step-1 -->
                    </div>
                    <!-- end wizard-content -->
                </div>
                <!-- end wizard -->
            </form>
            <!-- end wizard-form -->

  </div>
  <!-- end #content -->

  <?php $this->load->view('admin/inc/footer'); ?>


<!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/jquery-smart-wizard/src/css/smart_wizard.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/parsley/src/parsley.css'); ?>" rel="stylesheet" />
<!-- ================== END PAGE LEVEL STYLE ================== -->

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/parsley/dist/parsley.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/jquery-smart-wizard/src/js/jquery.smartWizard.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/form-wizards-validation.demo.min.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->
    
<script>
    $('#delete_form').submit( function(event) {
        var formId = this.id,
            form = this;
        
        $(".process-loader").append( "<div class='fa-3x'><i class='fas fa-spinner fa-pulse text-primary'></i></div>" );

        event.preventDefault();

        setTimeout( function () { 
            form.submit();
        }, 5000);
    }); 

    $(document).ready(function() {
        App.init();
        FormWizardValidation.init();
    });
</script>