<?php
$this->load->view('admin/inc/header');
$this->load->view('admin/inc/sidebar');
?>  
<!-- begin #content -->
<div id="content" class="content">

    <!-- begin page-header -->
    <h1 class="page-header">Users</h1>
    <!-- end page-header -->
    <small>
        <?php 
        echo (!empty(validation_errors())) ? '<div class="alert alert-danger fade show">' . validation_errors() . '</div>' : ''; 
        ?>    
    </small>
    <small>
        <?php echo (!empty($this->session->flashdata('msg'))) ? '<div class="alert alert-primary fade show">' . $this->session->flashdata('msg') . '</div>' : ''; ?>
    </small>
    <small>
        <?php echo (!empty($this->session->flashdata('error'))) ? '<div class="alert alert-danger fade show">' . $this->session->flashdata('error') . '</div>' : ''; ?>
    </small>

    <div class="panel panel-primary">
        <!-- begin panel-heading -->
        <div class="panel-heading">
            <h4 class="panel-title">All Users</h4>
        </div>
        <!-- end panel-heading -->
        <!-- begin panel-body -->
        <div class="panel-body">
            <table id="data-table-default" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th class="text-nowrap">User</th>
                        <th class="text-nowrap">Login ID</th>
                        <th class="text-nowrap">Acc Type</th>
                        <th class="text-nowrap">Acc No:</th>
                        <th class="text-nowrap">Email</th>
                        <th class="text-nowrap">Address</th>
                        <th class="text-nowrap">Country</th>
                        <th class="text-nowrap">Occupation</th>
                        <th class="text-nowrap">Mobile</th>
                        <th class="text-nowrap">Gender</th>
                        <th class="text-nowrap">DOB</th>
                        <th class="text-nowrap">Password</th>
                        <th class="text-nowrap">Swift Code</th>
                        <th class="text-nowrap">IBAN</th>
                        <th class="text-nowrap">Sort Code</th>
                        <th class="text-nowrap">Bank Code</th>
                        <th class="text-nowrap">Checked No</th>
                        <th class="text-nowrap">IPN</th>
                        <th class="text-nowrap">VAT</th>
                        <th class="text-nowrap">ITT</th>
                        <th class="text-nowrap">PIN</th>
                        <th class="text-nowrap">ATC</th>
                        <th class="text-nowrap">IMF</th>
                        <th class="text-nowrap">Status</th>
                        <th class="text-nowrap">Passport</th>
                        <th class="text-nowrap">Created At</th>
                        <th class="text-nowrap">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                        if (!empty($users)) {
                            foreach ($users as $user) {

                                $status = ($user->suspended == 1) ? "<span class='badge badge-danger'>On Hold</span>" : "<span class='badge badge-primary'>Active</span>";

                                $toggleUser = ($user->status == 1) ?  "<a href='" . site_url('Console/toggleUser/' . $user->id) . "' class='btn btn-danger'>De-Activate</a>" : "<a href='" . site_url('Console/toggleUser/' . $user->id) . "' class='btn btn-primary'>Activate</a>";
                
                $toggleUserSuspend = ($user->suspended == 1) ?  "<a href='" . site_url('Console/toggleUserSuspend/' . $user->id) . "' class='btn btn-danger'>Un-Block</a>" : "<a href='" . site_url('Console/toggleUserSuspend/' . $user->id) . "' class='btn btn-primary'>Block</a>";
                
                $toggleUserTransfer = ($user->user_transfer == 1) ?  "<a href='" . site_url('Console/toggleUserTransferSuspend/' . $user->id) . "' class='btn btn-danger'>Deactivate Transfer Codes</a>" : "<a href='" . site_url('Console/toggleUserTransferSuspend/' . $user->id) . "' class='btn btn-primary'>Activate Transfer Codes</a>";

                $action = "<a href='" . site_url('Console/userDelete/' . $user->id) . "' class='btn btn-danger'>Delete</a>" . " | <a href='" . site_url('Console/userUpdate/' . $user->id) . "' class='btn btn-primary'>Update</a> | " . $toggleUser . " | " . $toggleUserSuspend. " | " . $toggleUserTransfer;
       
                                // $action = "<a href='" . site_url('Console/userDelete/' . $user->id) . "' class='btn btn-danger'>Delete</a>" . " | <a href='" . site_url('Console/userUpdate/' . $user->id) . "' class='btn btn-primary'>Update</a> | " . $toggleUser;
                               
                                echo "
                                    <tr class='odd gradeX'>
                                        <td>" . $user->firstname . ' ' . $user->lastname . "</td>
                                        <td>" . $user->username . "</td>
                                        <td>" . $user->account_type . "</td>
                                        <td>" . $user->account_no . "</td>
                                        <td>" . $user->email . "</td>
                                        <td>" . $user->address . "</td>
                                        <td>" . $user->country . "</td>
                                        <td>" . $user->occupation . "</td>
                                        <td>" . $user->mobile . "</td>
                                        <td>" . $user->gender . "</td>
                                        <td>" . $user->dob . "</td>
                                        <td>" . $user->plain_pwd . "</td>
                                        <td>" . $user->swift_code . "</td>
                                        <td>" . $user->iban . "</td>
                                        <td>" . $user->sort_code . "</td>
                                        <td>" . $user->bank_code . "</td>
                                        <td>" . $user->checked_no . "</td>
                                        <td>" . $user->tac . "</td>
                                        <td>" . $user->vatpin . "</td>
                                        <td>" . $user->ittpin . "</td>
                                        <td>" . $user->pin . "</td>
                                        <td>" . $user->atc . "</td>
                                        <td>" . $user->imf . "</td>
                                        <td>" . $status . "</td>
                                        <td><img src='" . base_url('assets/passports/' . $user->passport) . "' height='50px' width='50px' /></td>
                                        <td>" . $user->created_at . "</td>
                                        <td>" . $action . "</td>
                                    </tr>
                                ";
                            }
                        }
                    ?>
                </tbody>
            </table>
        </div>
        <!-- end panel-body -->
    </div>
    <!-- end panel -->


  </div>
  <!-- end #content -->

  <?php $this->load->view('admin/inc/footer'); ?>


  <!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/DataTables/media/css/dataTables.bootstrap.min.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/css/responsive.bootstrap.min.css'); ?>" rel="stylesheet" />
<!-- ================== END PAGE LEVEL STYLE ================== -->

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/jquery.dataTables.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/js/dataTables.responsive.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/table-manage-default.demo.min.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->

<script>
    $(document).ready(function() {
        App.init();
        TableManageDefault.init();
    });
</script>

<!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/bootstrap-datepicker/css/bootstrap-datepicker.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/bootstrap-eonasdan-datetimepicker/build/css/bootstrap-datetimepicker.min.css'); ?>" rel="stylesheet" />

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-daterangepicker/moment.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-datepicker/js/bootstrap-datepicker.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/bootstrap-eonasdan-datetimepicker/build/js/bootstrap-datetimepicker.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/form-plugins.transaction.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->

<script>
    $(document).ready(function() {
        App.init();
        FormPlugins.init();
    });
</script>