<?php
$this->load->view('user/inc/header');
$this->load->view('user/inc/sidebar');
?>	
	<!-- begin #content -->
		<div id="content" class="content">
			
			<!-- begin page-header -->
			<h1 class="page-header">Card Application</h1>
			<!-- end page-header -->
			<small>
                <?php 
                    echo (!empty(validation_errors())) ? '<div class="alert alert-danger fade show">' . validation_errors() . '</div>' : ''; 
                ?>    
            </small>
            <small>
                <?php echo (!empty($this->session->flashdata('msg'))) ? '<div class="alert alert-primary fade show">' . $this->session->flashdata('msg') . '</div>' : ''; ?>
            </small>
            <small>
                <?php echo (!empty($this->session->flashdata('error'))) ? '<div class="alert alert-danger fade show">' . $this->session->flashdata('error') . '</div>' : ''; ?>
            </small>
			<!-- begin wizard-form -->
			<form id="card_form" action="<?php echo site_url('Customer/card/save'); ?>" method="POST" name="form-wizard" class="form-control-with-bg">
				<!-- begin wizard -->
				<div id="wizard">
					<!-- begin wizard-step -->
					<ul>
						<li class="col-md-4 col-sm-4 col-6">
							<a href="#step-1">
								<span class="number">1</span> 
								<span class="info text-ellipsis">
									Personal Info
									<small class="text-ellipsis">Name, Email, Acc, DOB</small>
								</span>
							</a>
						</li>
						<li class="col-md-4 col-sm-4 col-6">
							<a href="#step-2">
								<span class="number">2</span> 
								<span class="info text-ellipsis">
									Select Card Type
									<small class="text-ellipsis">Card Type, required</small>
								</span>
							</a>
						</li>
						<li class="col-md-4 col-sm-4 col-6">
							<a href="#step-3">
								<span class="number">3</span> 
								<span class="info text-ellipsis">
									Completed
									<small class="text-ellipsis">Submit Card Application</small>
								</span>
							</a>
						</li>
					</ul>
					<!-- end wizard-step -->
					<!-- begin wizard-content -->
					<div>
						<!-- begin step-1 -->
						<div id="step-1">
							<!-- begin fieldset -->
							<fieldset>
								<!-- begin row -->
								<div class="row">
									<!-- begin col-8 -->
									<div class="col-md-8 offset-md-2">
										<legend class="no-border f-w-700 p-b-0 m-t-0 m-b-20 f-s-16 text-inverse">Personal info about yourself</legend>
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">First Name <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" value="<?php echo $user->firstname; ?>" data-parsley-group="step-1" class="form-control" disabled />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Last Name <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" value="<?php echo $user->lastname; ?>" data-parsley-group="step-1" class="form-control" disabled />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Date of Birth <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" value="<?php echo $user->dob; ?>" data-parsley-group="step-1"  class="form-control" disabled />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Acc No <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" value="<?php echo $user->account_no; ?>" data-parsley-group="step-1" class="form-control" disabled />
											</div>
										</div>
										<!-- end form-group -->
										
									</div>
									<!-- end col-8 -->
								</div>
								<!-- end row -->
							</fieldset>
							<!-- end fieldset -->
						</div>
						<!-- end step-1 -->
						<!-- begin step-2 -->
						<div id="step-2">
							<!-- begin fieldset -->
							<fieldset>
								<!-- begin row -->
								<div class="row">
									<!-- begin col-8 -->
									<div class="col-md-8 md-offset-2">
										<legend class="no-border f-w-700 p-b-0 m-t-0 m-b-20 f-s-16 text-inverse">Your card details</legend>
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Acc No <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" value="<?php echo $user->account_no; ?>" data-parsley-group="step-2" data-parsley-required="true" class="form-control" disabled />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Card Type <span class="text-danger">*</span></label>
					                        <div class="col-md-6">
					                            <select class="form-control selectpicker" name="name" data-parsley-group="step-2" data-parsley-required="true">
					                                <option value=""> -- Select Card --</option>
					                                <option value="Credit Card">Credit Card</option>
					                                <option value="Debit Card">Debit Card</option>
					                                <option value="Charge Card">Charge Card</option>
					                                <option value="ATM Card">ATM Card</option>
					                                <option value="Fleet Card">Fleet Card</option>
					                            </select>
					                        </div>
						                </div>
									</div>
									<!-- end col-8 -->
								</div>
								<!-- end row -->
							</fieldset>
							<!-- end fieldset -->
						</div>
						<!-- end step-2 -->
						<!-- begin step-4 -->
						<div id="step-3">
							<div class="jumbotron m-b-0 text-center">
								<h2 class="text-inverse">Submit Card Application</h2>
								<div class="process-loader">
								</div>
								<p class="m-b-30 f-s-16">Your application for a transaction card will be reviewed. If you have confirmed and wish to continue with this application, kindly click on the "Submit Application" button. <br />For further enquiries on this process, kindly contact the Customer Support Agent (<?php echo $this->config->item('app_helpdesk_email'); ?>) for help.</p>
								<p><button type="submit" class="btn btn-primary btn-lg">Submit Application!</button></p>
							</div>
						</div>
						<!-- end step-4 -->
					</div>
					<!-- end wizard-content -->
				</div>
				<!-- end wizard -->
			</form>
			<!-- end wizard-form -->
		</div>
		<!-- end #content -->

<?php $this->load->view('user/inc/footer'); ?>


<!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/jquery-smart-wizard/src/css/smart_wizard.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/parsley/src/parsley.css'); ?>" rel="stylesheet" />
<!-- ================== END PAGE LEVEL STYLE ================== -->

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/parsley/dist/parsley.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/jquery-smart-wizard/src/js/jquery.smartWizard.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/form-wizards-validation.demo.min.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->
	
<script>
	$('#card_form').submit( function(event) {
	    var formId = this.id,
	        form = this;
	    
	    $(".process-loader").append( "<div class='fa-3x'><i class='fas fa-spinner fa-pulse text-primary'></i></div>" );

	    event.preventDefault();

	    setTimeout( function () { 
	        form.submit();
	    }, 5000);
	}); 

	$(document).ready(function() {
		App.init();
		FormWizardValidation.init();
	});
</script>