<?php
$this->load->view('user/inc/header');
$this->load->view('user/inc/sidebar');
?>
    <!-- begin #content -->
    <div id="content" class="content">

        <!-- begin page-header -->
        <h1 class="page-header">Welcome Back, <?php echo $user->firstname; ?> </small>
        </h1>
        <?php
                    // if ($this->app_model->user_suspended($this->session->userID)) {
                    //     echo "<div style='text-align:center' class='alert alert-danger fade show'>
                    //             <h5><strong><i class='fa fa-times'></i> Account On Hold!</strong>
                    //             Please Contact " . $this->config->item('app_info_email') . " for more info.</h5>" . 
                    //         "</div>";
                    // }
            ?>
            
            <?php
                    if ($this->app_model->user_suspended($this->session->userID)) {
                        echo "<div style='text-align:center' class='alert alert-danger fade show'>
                                <h5><strong><i class='fa fa-times'></i> Account Blocked!</strong>
                                Your account has been blocked for security reasons, this block is due to login from an unusual location, please contact live chat customer service for help or support.</h5>" . 
                            "</div>";
                    }
            ?>
            
            <?php
                  if (!empty($this->session->t_error)) {
                    echo "<div class='alert alert-danger'>" . $this->session->t_error . "</div>";
                  }
              ?>
              
              
        <!-- end page-header -->
        <div class="d-sm-flex align-items-center mb-3">
            <a href="#" class="btn btn-inverse mr-2 text-truncate">
                <i class="fa fa-calendar fa-fw text-white-transparent-5 ml-n1"></i>
                <span><?php echo date('F j, Y'); ?></span>
            </a>

        </div>
        <div class="row">

            

            <div class="col-xl-6">

                <div class="card border-0 mb-3 overflow-hidden bg-dark text-white">

                    <div class="card-body">

                        <div class="row">

                            <div class="col-xl-7 col-lg-8">

                                <div class="mb-3 text-white">
                                    <b>CURRENT BALANCE</b>
                                    <span class="ml-2"><i class="fa fa-info-circle" data-toggle="popover" data-trigger="hover" data-title="Balance" data-placement="top" data-content="Total Account Balance of this account, this balance changes with transactions" data-original-title="" title=""></i></span>
                                    
                                </div>

                                <div class="d-flex mb-1">
                                    <h2 class="mb-0 text-white">
                                        <?php echo $user->currency . number_format($this->app_model->get_user_account_balance($this->session->userID), 2) ;?>
                                    </h2>
                                </div>

                                <div class="mb-3 text-grey">
                                    <i class="fa fa-caret-up"></i> Main Account Balance
                                </div>

                                <hr class="bg-white-transparent-2" />

                                <div class="row text-truncate">

                                    <div class="col-6">
                                        <div class="f-s-12 text-grey">Total Credit Transaction</div>
                                        <div class="f-s-18 m-b-5 f-w-600 p-b-1" data-animation="number">
                                            <?php echo $user->currency . number_format($this->app_model->get_user_credits($this->session->userID), 2) ;?>
                                        </div>
                                        <div class="progress progress-xs rounded-lg bg-dark-darker m-b-5">
                                            <div class="progress-bar progress-bar-striped rounded-right bg-teal" data-animation="width" data-value="55%" style="width: 0%"></div>
                                        </div>
                                    </div>

                                    <div class="col-6">
                                        <div class="f-s-12 text-grey">Total Debit Transaction</div>
                                        <div class="f-s-18 m-b-5 f-w-600 p-b-1">
                                            <?php echo $user->currency . number_format($this->app_model->get_user_debits($this->session->userID) + $this->app_model->get_user_transfers($this->session->userID), 2) ;?>
                                        </div>
                                        <div class="progress progress-xs rounded-lg bg-dark-darker m-b-5">
                                            <div class="progress-bar progress-bar-striped rounded-right" data-animation="width" data-value="55%" style="width: 0%"></div>
                                        </div>
                                    </div>

                                </div>

                            </div>

                            <div class="col-xl-5 col-lg-4 align-items-center d-flex justify-content-center">
                                <img src="<?php echo base_url('assets/ui/transaction.png'); ?>" height="150px" class="d-none d-lg-block" />
                            </div>

                        </div>

                    </div>

                </div>

            </div>

            <div class="col-xl-6">

                <div class="row">

                    <div class="col-sm-6">

                        <div class="card border-0 text-truncate mb-3 bg-dark text-white">

                            <div class="card-body">

                                <div class="mb-3 text-grey">
                                    <b class="mb-3">ACCOUNT NUMBER</b>
                                 
                                </div>

                                <div class="d-flex align-items-center mb-1">
                                    <h2 class="text-white mb-0"><?php echo $user->account_no; ?></h2>
                                    <div class="ml-auto">
                                        <div id="conversion-rate-sparkline"></div>
                                    </div>
                                </div>

                                <div class="mb-4 text-grey">
                                    <hr />
                                   <!--  <i class="fa fa-caret-down"></i> <span data-animation="number" data-value="0.50">0.00</span>% compare to last week -->
                                </div>

                                <div class="d-flex mb-2">
                                    <div class="d-flex align-items-center">
                                        <i class="fa fa-circle text-red f-s-8 mr-2"></i> Login ID
                                    </div>
                                    <div class="d-flex align-items-center ml-auto">
                                        <div class="text-white f-w-600 f-s-11"><?php echo $user->username; ?></div>
                                    </div>
                                </div>

                                <div class="d-flex mb-2">
                                    <div class="d-flex align-items-center">
                                        <i class="fa fa-circle text-warning f-s-8 mr-2"></i> Account Status
                                    </div>
                                    <div class="d-flex align-items-center ml-auto">
                                        <div class="<?php echo $user->suspended==1 ? 'text-red' : 'text-green'; ?> f-w-800 f-s-11"><strong><?php echo $user->suspended==1 ? "ON HOLD" : "ACTIVE"; ?></strong></div>
                                    </div>
                                </div>

                                <div class="d-flex">
                                    <div class="d-flex align-items-center">
                                        <i class="fa fa-circle text-lime f-s-8 mr-2"></i> Account Type
                                    </div>
                                    <div class="d-flex align-items-center ml-auto">
                                        <div class="text-white f-w-600 f-s-11"><?php echo $user->account_type; ?></div>
                                    </div>
                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="col-sm-6">

                        <div class="card border-0 text-truncate mb-3 bg-dark text-white">

                            <div class="card-body">

                                <div class="mb-3 text-grey">
                                    <b class="mb-3">SECURITY BADGE</b>
                                    
                                </div>

                                <div class="d-flex align-items-center mb-1">
                                    <h2 class="text-white mb-0"><span data-animation="number" data-value="100">100</span>%</h2>
                                    <div class="ml-auto">
                                        <img src="<?php echo base_url('assets/ui/security2.png'); ?>" width="50px" height="50px">
                                        <img src="<?php echo base_url('assets/btc3.png'); ?>" width="40px" height="40px">
                                    </div>
                                </div>
                                <hr />
                                <p class="mb-4 d-flex align-items-justify text-grey">
                                   
                                    This site uses 256bit Security encryption.<br />
                                    Bitcoin Payment Accepted<br />

                                    <!-- Funds security is guaranteed. -->
                                </p>

                            </div>

                        </div>

                    </div>

                </div>

            </div>

        </div>

        <div class="row">


            <div class="col-xl-6 col-lg-6">

                <div class="card border-0 mb-3 bg-dark text-white">

                    <div class="card-body">

                        <div class="mb-3 text-grey">
                            <b>RECENT TRANSACTIONS</b>
                            <span class="ml-2 "><i class="fa fa-info-circle" data-toggle="popover" data-trigger="hover" data-title="RECENT TRANSACTIONS" data-placement="top" data-content="Recent transaction data are shown here"></i></span>
                        </div>


                                            <?php 
                                
                            $transfer_get = $this->db->limit(3)->order_by('id', 'DESC')->where('user_id', $this->session->userID)->where('status =', 1)->get('transfers')->result();

                            if (!empty($transfer_get)) {
                                foreach ($transfer_get as $transferred) {

                                    
                                            $status = "<span class='badge badge-success'>Approved</span>";
                                    

                                    $trans_id_url = site_url('Customer/transferVerification/' . $transferred->trans_id);
                        ?>

                            <div class="d-flex align-items-center m-b-15">
                                <div class="widget-img rounded-lg bg-warning m-r-10 p-3 width-30">
                                    <div class="h-100 w-100 text-white"><i class="fa fa-arrow-alt-circle-right m-l-5"></i></div>
                                </div>
                                <div class="text-truncate">
                                    <div>Beneficiary: <?php echo $transferred->ben_name . ' (' . $transferred->ben_account_name . ' ' . $transferred->ben_account_no . ')' ;?></div>
                                    <div class="text-grey">Bank/IBAN: <?php echo $transferred->ben_bank_name." / ".$transferred->ben_iban; ?></div>
                                    <div class="text-grey">
                                        SWIFT : <?php echo $transferred->ben_swift_code; ?>
                                    </div>
                                    <div class="text-grey">Trans. Date: <?php echo $transferred->date; ?></div>
                                    <div class="text-grey">Type : <?php echo $transferred->fund_option; ?></div>
                                    <div class="text-grey">Status : <?php echo $status; ?></div>
                                </div>
                                <div class="ml-auto text-center">
                                    <div class="f-s-14 text-danger text-bold"><span data-animation="number"><?php echo "-".$user->currency.number_format($transferred->amount, 2); ?></span></div>
                                    <div class="text-success f-s-12"><a class="btn btn-primary btn-xs" href="<?php echo $trans_id_url; ?>"> View Transfer</a></div>
                                </div>
                            </div>

                        <?php
                                }
                            }else {
                                echo '';
                            }
                        ?>

                        <?php 
                                
                            $transactions = $this->app_model->get_latest_transactions($this->session->userID);

                            if (!empty($transactions)) {
                                foreach ($transactions as $transaction) {

                                    $user_acc = $this->db->where('id', $transaction->user_id)->get('users')->row();

                                    $type = ($transaction->type == 'Debit') ? "<i class='fa fa-arrow-alt-circle-up m-l-5'></i>" : "<i class='fa fa-arrow-alt-circle-down m-l-5'></i>";
                        ?>

                            <div class="d-flex align-items-center m-b-15">
                                <div class="widget-img rounded-lg <?php echo $transaction->type == 'Debit' ? 'bg-danger' : 'bg-success' ;?> m-r-10 p-3 width-30">
                                    <div class="h-100 w-100 text-white"><?php echo $type; ?></div>
                                </div>
                                <div class="text-truncate">
                                    <div>Account: <?php echo ucfirst($user_acc->firstname) . ' ' . ucfirst($user_acc->lastname) . ' (' . $user_acc->account_no.')';?></div>
                                    <div class="text-grey">Narration: <?php echo $transaction->narration; ?></div>
                                    <div class="text-grey">Trans. Date: <?php echo $transaction->date; ?></div>
                                </div>
                                <div class="ml-auto text-center">
                                    <div class="f-s-14 <?php echo $transaction->type == 'Debit' ? 'text-danger' : 'text-success' ;?> text-bold"><span data-animation="number"><?php echo $transaction->type == 'Debit' ? '-' : '+' ;?><?php echo $user->currency . number_format($transaction->amount, 2); ?></span></div>
                                    <div class="<?php echo $transaction->type == 'Debit' ? 'text-danger' : 'text-success' ;?> f-s-12"><?php echo $transaction->type; ?></div>
                                </div>
                            </div>

                        <?php
                                }
                            }else {
                                echo '<div class="text-white text-center f-s-14">No Recent Transaction</div>';
                            }
                        ?>
                    </div>

                </div>

            </div>

            <div class="col-xl-6 col-lg-6">

                <div class="card border-0 mb-3 bg-dark text-white">

                    <div class="card-body">

                        <div class="mb-3 text-grey">
                            <b>RECENT TRANSFERS</b>
                            <span class="ml-2"><i class="fa fa-info-circle" data-toggle="popover" data-trigger="hover" data-title="RECENT TRANSFERS" data-placement="top" data-content="Most Recent Transfers"></i></span>
                        </div>

                        <?php
                            if (!empty($transfers)) {
                            
                                foreach ($transfers as $transfer) {

                                    switch($transfer->status){
                                        case 0:
                                            $status = "<span class='badge badge-danger'>Pending</span>";
                                            break;
                                        case 1:
                                            $status = "<span class='badge badge-success'>Approved</span>";
                                            break;
                                        case 2:
                                            $status = "<span class='badge badge-primary'>Reversed</span>";
                                            break;
                                    }
                                    // $status = ($transfer->status == 1) ? '<span class="badge badge-success">Approved</span>' : '<span class="badge badge-danger">Pending</span>';

                                    $trans_id_url = site_url('Customer/transferVerification/' . $transfer->trans_id);
                        ?>

                            <div class="d-flex align-items-center m-b-15">
                                <div class="widget-img rounded-lg bg-warning m-r-10 p-3 width-30">
                                    <div class="h-100 w-100 text-white"><i class="fa fa-arrow-alt-circle-right m-l-5"></i></div>
                                </div>
                                <div class="text-truncate">
                                    <div>Beneficiary: <?php echo $transfer->ben_name . ' (' . $transfer->ben_account_name . ' ' . $transfer->ben_account_no . ')' ;?></div>
                                    <div class="text-grey">Bank/IBAN: <?php echo $transfer->ben_bank_name." / ".$transfer->ben_iban; ?></div>
                                    <div class="text-grey">
                                        SWIFT : <?php echo $transfer->ben_swift_code; ?>
                                    </div>
                                    <div class="text-grey">Trans. Date: <?php echo $transfer->date; ?></div>
                                    <div class="text-grey">Type : <?php echo $transfer->fund_option; ?></div>
                                    <div class="text-grey">Status : <?php echo $status; ?></div>
                                </div>
                                <div class="ml-auto text-center">
                                    <div class="f-s-14 text-danger text-bold"><span data-animation="number"><?php echo "-".$user->currency.number_format($transfer->amount, 2); ?></span></div>
                                    <div class="text-success f-s-12"><a class="btn btn-primary btn-xs" href="<?php echo $trans_id_url; ?>"> View Transfer</a></div>
                                </div>
                            </div>

                        <?php
                                }
                            }else {
                                echo '<div class="text-white text-center f-s-14">No Recent Transfers</div>';
                            }
                        ?>


                    </div>

                </div>

            </div>

        </div>

        <?php // $this->load->view('user/inc/stats'); ?>

        <?php // $this->load->view('user/inc/recent-transactions'); ?>

    </div>
    <!-- end #content -->

    <?php $this->load->view('user/inc/footer'); ?>

    <!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
    <link href="<?php echo base_url('assets/ui/plugins/DataTables/media/css/dataTables.bootstrap.min.css'); ?>" rel="stylesheet" />
    <link href="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/css/responsive.bootstrap.min.css'); ?>" rel="stylesheet" />
    <!-- ================== END PAGE LEVEL STYLE ================== -->

    <!-- ================== BEGIN PAGE LEVEL JS ================== -->
    <script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/jquery.dataTables.js'); ?>"></script>
    <script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/js/dataTables.responsive.min.js'); ?>"></script>
    <script src="<?php echo base_url('assets/ui/js/demo/table-manage-default.demo.min.js'); ?>"></script>
    <!-- ================== END PAGE LEVEL JS ================== -->

    <script>
        $(document).ready(function() {
            App.init();
            TableManageDefault.init();
        });
    </script>