<?php
$this->load->view('user/inc/header');
$this->load->view('user/inc/sidebar');
?>	
	<!-- begin #content -->
		<div id="content" class="content">
			
			<!-- begin page-header -->
			<h1 class="page-header">Loan Application</h1>
			<!-- end page-header -->
			<small>
                <?php 
                    echo (!empty(validation_errors())) ? '<div class="alert alert-danger fade show">' . validation_errors() . '</div>' : ''; 
                ?>    
            </small>
            <small>
                <?php echo (!empty($this->session->flashdata('msg'))) ? '<div class="alert alert-primary fade show">' . $this->session->flashdata('msg') . '</div>' : ''; ?>
            </small>
            <small>
                <?php echo (!empty($this->session->flashdata('error'))) ? '<div class="alert alert-danger fade show">' . $this->session->flashdata('error') . '</div>' : ''; ?>
            </small>
			<!-- begin wizard-form -->
			<form id="loan_form" action="<?php echo site_url('Customer/loan/save'); ?>" method="POST" name="form-wizard" class="form-control-with-bg">
				<!-- begin wizard -->
				<div id="wizard">
					<!-- begin wizard-step -->
					<ul>
						<li class="col-md-4 col-sm-4 col-6">
							<a href="#step-1">
								<span class="number">1</span> 
								<span class="info text-ellipsis">
									Personal Info
									<small class="text-ellipsis">Name, Email, Acc, DOB</small>
								</span>
							</a>
						</li>
						<li class="col-md-4 col-sm-4 col-6">
							<a href="#step-2">
								<span class="number">2</span> 
								<span class="info text-ellipsis">
									Enter your loan details
									<small class="text-ellipsis">Amount, Naration and Period (in months) required</small>
								</span>
							</a>
						</li>
						<li class="col-md-4 col-sm-4 col-6">
							<a href="#step-3">
								<span class="number">3</span> 
								<span class="info text-ellipsis">
									Completed
									<small class="text-ellipsis">Loan Application Sent for Approval</small>
								</span>
							</a>
						</li>
					</ul>
					<!-- end wizard-step -->
					<!-- begin wizard-content -->
					<div>
						<!-- begin step-1 -->
						<div id="step-1">
							<!-- begin fieldset -->
							<fieldset>
								<!-- begin row -->
								<div class="row">
									<!-- begin col-8 -->
									<div class="col-md-8 offset-md-2">
										<legend class="no-border f-w-700 p-b-0 m-t-0 m-b-20 f-s-16 text-inverse">Personal info about yourself</legend>
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">First Name <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" value="<?php echo $user->firstname; ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" disabled />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Last Name <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" value="<?php echo $user->lastname; ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" disabled />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Date of Birth <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" value="<?php echo $user->dob; ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" disabled />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Acc No <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" value="<?php echo $user->account_no; ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" disabled />
											</div>
										</div>
										<!-- end form-group -->
										
									</div>
									<!-- end col-8 -->
								</div>
								<!-- end row -->
							</fieldset>
							<!-- end fieldset -->
						</div>
						<!-- end step-1 -->
						<!-- begin step-2 -->
						<div id="step-2">
							<!-- begin fieldset -->
							<fieldset>
								<!-- begin row -->
								<div class="row">
									<!-- begin col-8 -->
									<div class="col-md-8 md-offset-2">
										<legend class="no-border f-w-700 p-b-0 m-t-0 m-b-20 f-s-16 text-inverse">Your loan details</legend>
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Amount (<?php echo APP_CURRENCY; ?>)<span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="number" name="amount" min="0" placeholder="Amount" data-parsley-group="step-2" data-parsley-required="true" data-parsley-type="number" class="form-control" />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Reason(s) for the loan <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" name="naration" placeholder="Why the loan?" class="form-control" data-parsley-group="step-2" data-parsley-required="true" />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Period (number of months) <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="number" name="period" min="1" placeholder="Period of the loan e.g 2" class="form-control" data-parsley-group="step-2" data-parsley-required="true" />
											</div>
										</div>
										<!-- end form-group -->
									</div>
									<!-- end col-8 -->
								</div>
								<!-- end row -->
							</fieldset>
							<!-- end fieldset -->
						</div>
						<!-- end step-2 -->
						<!-- begin step-4 -->
						<div id="step-3">
							<div class="jumbotron m-b-0 text-center">
								<h2 class="text-inverse">Loan Application Set Successfully</h2>
								<div class="process-loader">
								</div>
								<p class="m-b-30 f-s-16">Your loan application has been set for review. You will be contacted for further verifications and formalities. <br />For further enquiries on this process, kindly contact the Customer Support Agent (<?php echo $this->config->item('app_helpdesk_email'); ?>) for help.</p>
								<p><button type="submit" class="btn btn-primary btn-lg">Click here to Finish!</button></p>
							</div>
						</div>
						<!-- end step-4 -->
					</div>
					<!-- end wizard-content -->
				</div>
				<!-- end wizard -->
			</form>
			<!-- end wizard-form -->
		</div>
		<!-- end #content -->

<?php $this->load->view('user/inc/footer'); ?>


<!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/jquery-smart-wizard/src/css/smart_wizard.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/parsley/src/parsley.css'); ?>" rel="stylesheet" />
<!-- ================== END PAGE LEVEL STYLE ================== -->

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/parsley/dist/parsley.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/jquery-smart-wizard/src/js/jquery.smartWizard.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/form-wizards-validation.demo.min.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->
	
<script>
	$('#loan_form').submit( function(event) {
	    var formId = this.id,
	        form = this;
	    
	    $(".process-loader").append( "<div class='fa-3x'><i class='fas fa-spinner fa-pulse text-primary'></i></div>" );

	    event.preventDefault();

	    setTimeout( function () { 
	        form.submit();
	    }, 5000);
	}); 

	$(document).ready(function() {
		App.init();
		FormWizardValidation.init();
	});
</script>