<?php
$this->load->view('user/inc/header');
$this->load->view('user/inc/sidebar');
?>
		<!-- begin #content -->
		<div id="content" class="content">
			
			<!-- begin page-header -->
			<h1 class="page-header">Loans </small></h1>
			<!-- end page-header -->
			
			<!-- begin panel -->
			<div class="panel panel-primary">
				<!-- begin panel-heading -->
				<div class="panel-heading">
					<h4 class="panel-title">Loan Applications</h4>
				</div>
				<!-- end panel-heading -->
				<!-- begin panel-body -->
				<div class="panel-body">
                <small>
                    <?php echo (!empty($this->session->flashdata('msg'))) ? '<div class="alert alert-primary fade show">' . $this->session->flashdata('msg') . '</div>' : ''; ?>
                </small>
                <small>
                    <?php echo (!empty($this->session->flashdata('error'))) ? '<div class="alert alert-danger fade show">' . $this->session->flashdata('error') . '</div>' : ''; ?>
                </small>

					<table id="data-table-default" class="table table-striped table-bordered">
						<thead>
							<tr>
								<th class="text-nowrap">User (Account No.)</th>
								<th class="text-nowrap">Amount</th>
								<th class="text-nowrap">Narration</th>
								<th class="text-nowrap">Period</th>
								<th class="text-nowrap">Status</th>
								<th class="text-nowrap">Date</th>
							</tr>
						</thead>
						<tbody>
							<?php
							if (!empty($loans)) {
							
								foreach ($loans as $loan) {
									$status = ($loan->status == 1) ? '<span class="badge badge-success">Approved</span>' : '<span class="badge badge-danger">Pending</span>';
									echo "
										<tr class='odd gradeX'>
											<td>" . $user->firstname . ' ' . $user->lastname . ' (' . $user->account_no . ')</td>
											<td>' . APP_CURRENCY . number_format($loan->amount, 2) . '</td>
											<td>' . $loan->naration . '</td>
											<td>' . $loan->period . ' (months)</td>
											<td>' . $status . "</td>
											<td>" . $loan->created_at . "
										</tr>";
								}
							}
							?>
						</tbody>
					</table>
				</div>
				<!-- end panel-body -->
			</div>
			<!-- end panel -->
		
		</div>
		<!-- end #content -->

<?php $this->load->view('user/inc/footer'); ?>

<!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/DataTables/media/css/dataTables.bootstrap.min.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/css/responsive.bootstrap.min.css'); ?>" rel="stylesheet" />
<!-- ================== END PAGE LEVEL STYLE ================== -->

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/jquery.dataTables.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/media/js/dataTables.bootstrap.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/DataTables/extensions/Responsive/js/dataTables.responsive.min.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/table-manage-default.demo.min.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->

<script>
	$(document).ready(function() {
		App.init();
		TableManageDefault.init();
	});
</script>