<?php
$this->load->view('user/inc/header');
$this->load->view('user/inc/sidebar');
?>	
	<!-- begin #content -->
		<div id="content" class="content">
			
			<!-- begin page-header -->
			<h1 class="page-header">Fund Transfer</h1>
			<!-- end page-header -->
			<small>
                <?php 
                    echo (!empty(validation_errors())) ? '<div class="alert alert-danger fade show">' . validation_errors() . '</div>' : ''; 
                ?>    
            </small>
            <small>
                <?php echo (!empty($this->session->flashdata('msg'))) ? '<div class="alert alert-primary fade show">' . $this->session->flashdata('msg') . '</div>' : ''; ?>
            </small>
            <small>
                <?php echo (!empty($this->session->flashdata('error'))) ? '<div class="alert alert-danger fade show">' . $this->session->flashdata('error') . '</div>' : ''; ?>
            </small>
			<!-- begin wizard-form -->
			<form id="transfer_form" action="<?php echo site_url('Customer/transfer/save'); ?>" method="POST" name="form-wizard" class="form-control-with-bg">
				<!-- begin wizard -->
				<div id="wizard">
					<!-- begin wizard-step -->
					<ul>
						<li class="col-md-6 col-sm-6 col-6">
							<a href="#step-1">
								<span class="number">1</span> 
								<span class="info text-ellipsis">
									Beneficiary Account Details
									<small class="text-ellipsis">Bank Name, Account Name, Country...</small>
								</span>
							</a>
						</li>
						<li class="col-md-6 col-sm-6 col-6">
							<a href="#step-2">
								<span class="number">2</span> 
								<span class="info text-ellipsis">
									Completed
									<small class="text-ellipsis">Fund Transfer Set for Approval</small>
								</span>
							</a>
						</li>
					</ul>
					<!-- end wizard-step -->
					<!-- begin wizard-content -->
					<div>
						<!-- begin step-1 -->
						<div id="step-1">
							<!-- begin fieldset -->
							<fieldset>
								<!-- begin row -->
								<div class="row">
									<!-- begin col-6 -->
									<div class="col-md-6">
										<legend class="no-border f-w-700 p-b-0 m-t-0 m-b-20 f-s-16 text-inverse">Beneficiary's Account Detials</legend>
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">User Name<span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" value="<?php echo $user->firstname . ' ' . $user->lastname; ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" disabled />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Account Number <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" value="<?php echo $user->account_no; ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" disabled />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Beneficiary's Bank Name <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" name="ben_bank_name" value="<?php echo set_value('ben_bank_name'); ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Beneficiary's Account No <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" name="ben_account_no" value="<?php echo set_value('ben_account_no'); ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Beneficiary's Account Name <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" name="ben_account_name" value="<?php echo set_value('ben_account_name'); ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Beneficiary's Name <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" name="ben_name" value="<?php echo set_value('ben_name'); ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" />
											</div>
										</div>
										<!-- end form-group -->

									</div>
									<!-- end col-6 -->
									<!-- begin col-6 -->
									<div class="col-md-6">
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Beneficiary's Bank Address <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" name="ben_bank_address" value="<?php echo set_value('ben_bank_address'); ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Country <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<select class="form-control selectpicker" name="country" data-size="10" data-live-search="true" data-style="btn-white" required>
					                                <option value="" selected>Select a Country</option>
					                                <option value="Afganistan">Afghanistan</option>
					                                <option value="Albania">Albania</option>
					                                <option value="Algeria">Algeria</option>
					                                <option value="American Samoa">American Samoa</option>
					                                <option value="Andorra">Andorra</option>
					                                <option value="Angola">Angola</option>
					                                <option value="Anguilla">Anguilla</option>
					                                <option value="Antigua &amp; Barbuda">Antigua &amp; Barbuda</option>
					                                <option value="Argentina">Argentina</option>
					                                <option value="Armenia">Armenia</option>
					                                <option value="Aruba">Aruba</option>
					                                <option value="Australia">Australia</option>
					                                <option value="Austria">Austria</option>
					                                <option value="Azerbaijan">Azerbaijan</option>
					                                <option value="Bahamas">Bahamas</option>
					                                <option value="Bahrain">Bahrain</option>
					                                <option value="Bangladesh">Bangladesh</option>
					                                <option value="Barbados">Barbados</option>
					                                <option value="Belarus">Belarus</option>
					                                <option value="Belgium">Belgium</option>
					                                <option value="Belize">Belize</option>
					                                <option value="Benin">Benin</option>
					                                <option value="Bermuda">Bermuda</option>
					                                <option value="Bhutan">Bhutan</option>
					                                <option value="Bolivia">Bolivia</option>
					                                <option value="Bonaire">Bonaire</option>
					                                <option value="Bosnia &amp; Herzegovina">Bosnia &amp; Herzegovina</option>
					                                <option value="Botswana">Botswana</option>
					                                <option value="Brazil">Brazil</option>
					                                <option value="British Indian Ocean Ter">British Indian Ocean Ter</option>
					                                <option value="Brunei">Brunei</option>
					                                <option value="Bulgaria">Bulgaria</option>
					                                <option value="Burkina Faso">Burkina Faso</option>
					                                <option value="Burundi">Burundi</option>
					                                <option value="Cambodia">Cambodia</option>
					                                <option value="Cameroon">Cameroon</option>
					                                <option value="Canada">Canada</option>
					                                <option value="Canary Islands">Canary Islands</option>
					                                <option value="Cape Verde">Cape Verde</option>
					                                <option value="Cayman Islands">Cayman Islands</option>
					                                <option value="Central African Republic">Central African Republic</option>
					                                <option value="Chad">Chad</option>
					                                <option value="Channel Islands">Channel Islands</option>
					                                <option value="Chile">Chile</option>
					                                <option value="China">China</option>
					                                <option value="Christmas Island">Christmas Island</option>
					                                <option value="Cocos Island">Cocos Island</option>
					                                <option value="Colombia">Colombia</option>
					                                <option value="Comoros">Comoros</option>
					                                <option value="Congo">Congo</option>
					                                <option value="Cook Islands">Cook Islands</option>
					                                <option value="Costa Rica">Costa Rica</option>
					                                <option value="Cote DIvoire">Cote D'Ivoire</option>
					                                <option value="Croatia">Croatia</option>
					                                <option value="Cuba">Cuba</option>
					                                <option value="Curaco">Curacao</option>
					                                <option value="Cyprus">Cyprus</option>
					                                <option value="Czech Republic">Czech Republic</option>
					                                <option value="Denmark">Denmark</option>
					                                <option value="Djibouti">Djibouti</option>
					                                <option value="Dominica">Dominica</option>
					                                <option value="Dominican Republic">Dominican Republic</option>
					                                <option value="East Timor">East Timor</option>
					                                <option value="Ecuador">Ecuador</option>
					                                <option value="Egypt">Egypt</option>
					                                <option value="El Salvador">El Salvador</option>
					                                <option value="Equatorial Guinea">Equatorial Guinea</option>
					                                <option value="Eritrea">Eritrea</option>
					                                <option value="Estonia">Estonia</option>
					                                <option value="Ethiopia">Ethiopia</option>
					                                <option value="Falkland Islands">Falkland Islands</option>
					                                <option value="Faroe Islands">Faroe Islands</option>
					                                <option value="Fiji">Fiji</option>
					                                <option value="Finland">Finland</option>
					                                <option value="France">France</option>
					                                <option value="French Guiana">French Guiana</option>
					                                <option value="French Polynesia">French Polynesia</option>
					                                <option value="French Southern Ter">French Southern Ter</option>
					                                <option value="Gabon">Gabon</option>
					                                <option value="Gambia">Gambia</option>
					                                <option value="Georgia">Georgia</option>
					                                <option value="Germany">Germany</option>
					                                <option value="Ghana">Ghana</option>
					                                <option value="Gibraltar">Gibraltar</option>
					                                <option value="Great Britain">Great Britain</option>
					                                <option value="Greece">Greece</option>
					                                <option value="Greenland">Greenland</option>
					                                <option value="Grenada">Grenada</option>
					                                <option value="Guadeloupe">Guadeloupe</option>
					                                <option value="Guam">Guam</option>
					                                <option value="Guatemala">Guatemala</option>
					                                <option value="Guinea">Guinea</option>
					                                <option value="Guyana">Guyana</option>
					                                <option value="Haiti">Haiti</option>
					                                <option value="Hawaii">Hawaii</option>
					                                <option value="Honduras">Honduras</option>
					                                <option value="Hong Kong">Hong Kong</option>
					                                <option value="Hungary">Hungary</option>
					                                <option value="Iceland">Iceland</option>
					                                <option value="India">India</option>
					                                <option value="Indonesia">Indonesia</option>
					                                <option value="Iran">Iran</option>
					                                <option value="Iraq">Iraq</option>
					                                <option value="Ireland">Ireland</option>
					                                <option value="Isle of Man">Isle of Man</option>
					                                <option value="Israel">Israel</option>
					                                <option value="Italy">Italy</option>
					                                <option value="Jamaica">Jamaica</option>
					                                <option value="Japan">Japan</option>
					                                <option value="Jordan">Jordan</option>
					                                <option value="Kazakhstan">Kazakhstan</option>
					                                <option value="Kenya">Kenya</option>
					                                <option value="Kiribati">Kiribati</option>
					                                <option value="Korea North">Korea North</option>
					                                <option value="Korea Sout">Korea South</option>
					                                <option value="Kuwait">Kuwait</option>
					                                <option value="Kyrgyzstan">Kyrgyzstan</option>
					                                <option value="Laos">Laos</option>
					                                <option value="Latvia">Latvia</option>
					                                <option value="Lebanon">Lebanon</option>
					                                <option value="Lesotho">Lesotho</option>
					                                <option value="Liberia">Liberia</option>
					                                <option value="Libya">Libya</option>
					                                <option value="Liechtenstein">Liechtenstein</option>
					                                <option value="Lithuania">Lithuania</option>
					                                <option value="Luxembourg">Luxembourg</option>
					                                <option value="Macau">Macau</option>
					                                <option value="Macedonia">Macedonia</option>
					                                <option value="Madagascar">Madagascar</option>
					                                <option value="Malaysia">Malaysia</option>
					                                <option value="Malawi">Malawi</option>
					                                <option value="Maldives">Maldives</option>
					                                <option value="Mali">Mali</option>
					                                <option value="Malta">Malta</option>
					                                <option value="Marshall Islands">Marshall Islands</option>
					                                <option value="Martinique">Martinique</option>
					                                <option value="Mauritania">Mauritania</option>
					                                <option value="Mauritius">Mauritius</option>
					                                <option value="Mayotte">Mayotte</option>
					                                <option value="Mexico">Mexico</option>
					                                <option value="Midway Islands">Midway Islands</option>
					                                <option value="Moldova">Moldova</option>
					                                <option value="Monaco">Monaco</option>
					                                <option value="Mongolia">Mongolia</option>
					                                <option value="Montserrat">Montserrat</option>
					                                <option value="Morocco">Morocco</option>
					                                <option value="Mozambique">Mozambique</option>
					                                <option value="Myanmar">Myanmar</option>
					                                <option value="Nambia">Nambia</option>
					                                <option value="Nauru">Nauru</option>
					                                <option value="Nepal">Nepal</option>
					                                <option value="Netherland Antilles">Netherland Antilles</option>
					                                <option value="Netherlands">Netherlands (Holland, Europe)</option>
					                                <option value="Nevis">Nevis</option>
					                                <option value="New Caledonia">New Caledonia</option>
					                                <option value="New Zealand">New Zealand</option>
					                                <option value="Nicaragua">Nicaragua</option>
					                                <option value="Niger">Niger</option>
					                                <option value="Nigeria">Nigeria</option>
					                                <option value="Niue">Niue</option>
					                                <option value="Norfolk Island">Norfolk Island</option>
					                                <option value="Norway">Norway</option>
					                                <option value="Oman">Oman</option>
					                                <option value="Pakistan">Pakistan</option>
					                                <option value="Palau Island">Palau Island</option>
					                                <option value="Palestine">Palestine</option>
					                                <option value="Panama">Panama</option>
					                                <option value="Papua New Guinea">Papua New Guinea</option>
					                                <option value="Paraguay">Paraguay</option>
					                                <option value="Peru">Peru</option>
					                                <option value="Phillipines">Philippines</option>
					                                <option value="Pitcairn Island">Pitcairn Island</option>
					                                <option value="Poland">Poland</option>
					                                <option value="Portugal">Portugal</option>
					                                <option value="Puerto Rico">Puerto Rico</option>
					                                <option value="Qatar">Qatar</option>
					                                <option value="Republic of Montenegro">Republic of Montenegro</option>
					                                <option value="Republic of Serbia">Republic of Serbia</option>
					                                <option value="Reunion">Reunion</option>
					                                <option value="Romania">Romania</option>
					                                <option value="Russia">Russia</option>
					                                <option value="Rwanda">Rwanda</option>
					                                <option value="St Barthelemy">St Barthelemy</option>
					                                <option value="St Eustatius">St Eustatius</option>
					                                <option value="St Helena">St Helena</option>
					                                <option value="St Kitts-Nevis">St Kitts-Nevis</option>
					                                <option value="St Lucia">St Lucia</option>
					                                <option value="St Maarten">St Maarten</option>
					                                <option value="St Pierre &amp; Miquelon">St Pierre &amp; Miquelon</option>
					                                <option value="St Vincent &amp; Grenadines">St Vincent &amp; Grenadines</option>
					                                <option value="Saipan">Saipan</option>
					                                <option value="Samoa">Samoa</option>
					                                <option value="Samoa American">Samoa American</option>
					                                <option value="San Marino">San Marino</option>
					                                <option value="Sao Tome &amp; Principe">Sao Tome &amp; Principe</option>
					                                <option value="Saudi Arabia">Saudi Arabia</option>
					                                <option value="Senegal">Senegal</option>
					                                <option value="Serbia">Serbia</option>
					                                <option value="Seychelles">Seychelles</option>
					                                <option value="Sierra Leone">Sierra Leone</option>
					                                <option value="Singapore">Singapore</option>
					                                <option value="Slovakia">Slovakia</option>
					                                <option value="Slovenia">Slovenia</option>
					                                <option value="Solomon Islands">Solomon Islands</option>
					                                <option value="Somalia">Somalia</option>
					                                <option value="South Africa">South Africa</option>
					                                <option value="Spain">Spain</option>
					                                <option value="Sri Lanka">Sri Lanka</option>
					                                <option value="Sudan">Sudan</option>
					                                <option value="Suriname">Suriname</option>
					                                <option value="Swaziland">Swaziland</option>
					                                <option value="Sweden">Sweden</option>
					                                <option value="Switzerland">Switzerland</option>
					                                <option value="Syria">Syria</option>
					                                <option value="Tahiti">Tahiti</option>
					                                <option value="Taiwan">Taiwan</option>
					                                <option value="Tajikistan">Tajikistan</option>
					                                <option value="Tanzania">Tanzania</option>
					                                <option value="Thailand">Thailand</option>
					                                <option value="Togo">Togo</option>
					                                <option value="Tokelau">Tokelau</option>
					                                <option value="Tonga">Tonga</option>
					                                <option value="Trinidad &amp; Tobago">Trinidad &amp; Tobago</option>
					                                <option value="Tunisia">Tunisia</option>
					                                <option value="Turkey">Turkey</option>
					                                <option value="Turkmenistan">Turkmenistan</option>
					                                <option value="Turks &amp; Caicos Is">Turks &amp; Caicos Is</option>
					                                <option value="Tuvalu">Tuvalu</option>
					                                <option value="Uganda">Uganda</option>
					                                <option value="Ukraine">Ukraine</option>
					                                <option value="United Arab Erimates">United Arab Emirates</option>
					                                <option value="United Kingdom">United Kingdom</option>
					                                <option value="United States of America">United States of America</option>
					                                <option value="Uraguay">Uruguay</option>
					                                <option value="Uzbekistan">Uzbekistan</option>
					                                <option value="Vanuatu">Vanuatu</option>
					                                <option value="Vatican City State">Vatican City State</option>
					                                <option value="Venezuela">Venezuela</option>
					                                <option value="Vietnam">Vietnam</option>
					                                <option value="Virgin Islands (Brit)">Virgin Islands (Brit)</option>
					                                <option value="Virgin Islands (USA)">Virgin Islands (USA)</option>
					                                <option value="Wake Island">Wake Island</option>
					                                <option value="Wallis &amp; Futana Is">Wallis &amp; Futana Is</option>
					                                <option value="Yemen">Yemen</option>
					                                <option value="Zaire">Zaire</option>
					                                <option value="Zambia">Zambia</option>
					                                <option value="Zimbabwe">Zimbabwe</option>
					                            </select>
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Amount (<?php echo APP_CURRENCY; ?>)<span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="number" name="amount" value="<?php echo set_value('amount'); ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Fund Transfer Options <span class="text-danger">*</span></label>
					                        <div class="col-md-6">
					                            <select class="form-control selectpicker" name="fund_option" data-parsley-group="step-1" data-parsley-required="true">
					                                <option value=""> -- Select Transfer Options --</option>
					                                <option value="International Transfer">International Transfer</option>
					                                <option value="Local Transfer">Local Transfer</option>
					                            </select>
					                        </div>
						                </div>
						                <!-- end form-group -->
						                <!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">IBAN (if any)</label>
											<div class="col-md-6">
												<input type="text" name="ben_iban" value="<?php echo set_value('ben_iban'); ?>" data-parsley-group="step-1" class="form-control" />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Bank Swift/BIC Code <span class="text-danger">*</span></label>
											<div class="col-md-6">
												<input type="text" name="ben_swift_code" value="<?php echo set_value('ben_swift_code'); ?>" data-parsley-group="step-1" data-parsley-required="true" class="form-control" />
											</div>
										</div>
										<!-- end form-group -->
										<!-- begin form-group -->
										<div class="form-group row m-b-10">
											<label class="col-md-3 col-form-label text-md-right">Transaction Description<span class="text-danger">*</span></label>
											<div class="col-md-6">
												<textarea name="narration" data-parsley-group="step-1" data-parsley-required="true" class="form-control"><?php echo set_value('narration'); ?></textarea>
											</div>
										</div>
										<!-- end form-group -->
									</div>
									<!-- end col-6 -->

								</div>
								<!-- end row -->
							</fieldset>
							<!-- end fieldset -->
						</div>
						<!-- end step-1 -->
						
						<!-- begin step-4 -->
						<div id="step-2">
							<div class="jumbotron m-b-0 text-center">
								<h2 class="text-inverse">Fund Transfer Initiated!</h2>
								<div class="process-loader">
								</div>
								<p class="m-b-30 f-s-16">Dear Esteemed Customer, you have initiated an Inter-Bank Transfer Transaction. If you wish to continue with this action, kindly click on the "Submit Request". <br />For further enquiries on this process, please contact the Customer Support Agent (<?php echo $this->config->item('app_helpdesk_email'); ?>) for help. </p>
								<p><button type="submit" class="btn btn-primary btn-lg">Submit Request!</button></p>
							</div>
						</div>
						<!-- end step-4 -->
					</div>
					<!-- end wizard-content -->
				</div>
				<!-- end wizard -->
			</form>
			<!-- end wizard-form -->
		</div>
		<!-- end #content -->

<?php $this->load->view('user/inc/footer'); ?>


<!-- ================== BEGIN PAGE LEVEL STYLE ================== -->
<link href="<?php echo base_url('assets/ui/plugins/jquery-smart-wizard/src/css/smart_wizard.css'); ?>" rel="stylesheet" />
<link href="<?php echo base_url('assets/ui/plugins/parsley/src/parsley.css'); ?>" rel="stylesheet" />
<!-- ================== END PAGE LEVEL STYLE ================== -->

<!-- ================== BEGIN PAGE LEVEL JS ================== -->
<script src="<?php echo base_url('assets/ui/plugins/parsley/dist/parsley.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/plugins/jquery-smart-wizard/src/js/jquery.smartWizard.js'); ?>"></script>
<script src="<?php echo base_url('assets/ui/js/demo/form-wizards-validation.demo.min.js'); ?>"></script>
<!-- ================== END PAGE LEVEL JS ================== -->
	
<script>
	$('#transfer_form').submit( function(event) {
	    var formId = this.id,
	        form = this;
	    
	    $(".process-loader").append( "<div class='fa-3x'><i class='fas fa-spinner fa-pulse text-primary'></i></div>" );

	    event.preventDefault();

	    setTimeout( function () { 
	        form.submit();
	    }, 10000);
	}); 

	$(document).ready(function() {
		App.init();
		FormWizardValidation.init();
	});
</script>